% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotRegNB}
\alias{plotRegNB}
\title{Function for plotting negative binomial regression}
\usage{
plotRegNB(expData, y, par.nb = NULL, span = 0.75, ...)
}
\arguments{
\item{expData}{Matrix of gene expression values with genes as rows and cells as columns. The matrix needs to contain the same cell IDs as columns like the input matrix.
used to derive the pruned k nearest neighbours with the \code{pruneKnn} function.}

\item{y}{List object returned by the \code{compNoise} or \code{pruneKnn} function (if run with \code{regNB=TRUE}).}

\item{par.nb}{Parameter to be plotted, i.e. valid column of \code{res$regData$nbRegr}.
of the log total UMI count. \code{intercept} is the intercept inferred by the regression. Default is \code{NULL} and \code{theta} is shown.}

\item{span}{Positive real number. Parameter for loess-regression (see \code{large}) controlling the degree of smoothing. Default is 0.75.}

\item{...}{Additional arguments for \code{plot}.}
}
\value{
None
}
\description{
This function plots the parameters obatined by the negative binomial regression of the transcript counts on the total transcript count in each cells.
Smoothed parameter estimates are also shown.
}
\examples{
res <- pruneKnn(intestinalDataSmall,no_cores=1)
plotRegNB(intestinalDataSmall,res,"theta")
}
