% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotQQ}
\alias{plotQQ}
\title{Scatter plot of two noise-related quantaties of local pruned k-nearest neighbourhoods}
\usage{
plotQQ(x, m, n, object, cluster = NULL, cex = 0.5, show.cor = TRUE, ...)
}
\arguments{
\item{x}{List object returned by \code{quantKnn} function.}

\item{m}{Component name of \code{x}. One of "noise.av", "noise.ratio", "local.corr", "umi".}

\item{n}{Component name of \code{x}. One of "noise.av", "noise.ratio", "local.corr", "umi".}

\item{object}{\code{SCseq} class object.}

\item{cluster}{Valid cluster number or vector of cluster numbers, contained in \code{object@cpart}. If given, then cells of clusters in \code{cluster} are circled in black.}

\item{cex}{Real positive number. Size of data points. Default is 0.5.}

\item{show.cor}{logical. If \code{TRUE} then Pearson's correlation is shown in the legend. Default is \code{TRUE}.}

\item{...}{Additional parameters of \code{plot} (e.g., \code{log}, see \code{help(plot)}).}
}
\value{
None
}
\description{
Displaying two noise-related quantaties of local pruned k-nearest neighbourhoods in a scatterplot highlighting VarID clusters.
}
