% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_procrustes.R
\name{procrustesMap}
\alias{procrustesMap}
\title{Return procrustes information}
\usage{
procrustesMap(
  map,
  comparison_map,
  optimization_number = 1,
  comparison_optimization_number = 1,
  antigens = TRUE,
  sera = TRUE,
  translation = TRUE,
  scaling = FALSE,
  keep_optimizations = FALSE
)
}
\arguments{
\item{map}{The acmap data object}

\item{comparison_map}{The acmap data object to procrustes against}

\item{optimization_number}{The map optimization to use in the procrustes
calculation (other optimization runs are discarded)}

\item{comparison_optimization_number}{The optimization run int the comparison
map to compare against}

\item{antigens}{Antigens to include (specified by name or index or TRUE/FALSE
for all/none)}

\item{sera}{Sera to include (specified by name or index or TRUE/FALSE for
all/none)}

\item{translation}{Should translation be allowed}

\item{scaling}{Should scaling be allowed (generally not recommended unless
comparing maps made with different assays)}

\item{keep_optimizations}{Should all optimization runs be kept or only the
one to which the procrustes was applied.}
}
\value{
Returns an acmap object with procrustes information added, which will
be shown when the map is plotted. To avoid ambiguity about which
optimization run the procrustes was applied to, only the optimization run
specified by \code{optimization_number} is kept in the map returned.
}
\description{
Returns information from one map procrusted to another.
}
\seealso{
Other functions to compare maps: 
\code{\link{matchStrains}},
\code{\link{procrustesData}()},
\code{\link{realignMap}()},
\code{\link{realignOptimizations}()}
}
\concept{functions to compare maps}
