% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.density.R
\name{do.density}
\alias{do.density}
\title{Computes 2D density for contour plots of Radviz objects}
\usage{
do.density(x, n = 50)
}
\arguments{
\item{x}{a radviz object as produced by do.radviz}

\item{n}{Number of grid points in each direction. Can be scalar or a length-2
integer vector (see \link[MASS]{kde2d} for details)}
}
\value{
the Radviz object with and extra slot \code{density} containing the 2D density
estimates for use with \code{\link{contour.radviz}}
}
\description{
Computes 2D density estimate of projected data for a Radivz object,
using the \code{\link[MASS]{kde2d}} function from the \pkg{MASS} package
}
\details{
Computes a 2D density estimate of Radviz projected data and stores the results
           in a \code{density} slot of the Radviz object. Invalid points, if any, will be
           excluded.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
rv <- do.density(rv)
contour(rv,point.shape=1,point.color=c('red','green','blue')[as.integer(iris$Species)])

}
\author{
Yann Abraham
}
\seealso{
\link{contour.radviz} for plotting
}

