% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.valid.R
\name{is.valid}
\alias{is.valid}
\title{Identify the valid projections from a Radviz object}
\usage{
is.valid(x)
}
\arguments{
\item{x}{an object of class Radviz, as returned by \code{\link{do.radviz}}}
}
\description{
The function will return a vector as long as the data in x where points that could not be projected are \code{TRUE}
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
iris0 <- rbind(iris,c(rep(0,length(das)),NA))
S <- make.S(das)
rv0 <- do.radviz(iris0,S)

sum(!is.valid(rv0)) # should be 1

# to find which points where invalid in the data
which(!is.valid(rv0))

# to review the original data points
rv1 <- subset(rv0,is.valid(rv0))

summary(rv1)
}
\author{
Yann Abraham
}
