\name{EuclRandVariable}
\alias{EuclRandVariable}
\title{Generating function for EuclRandVariable-class}
\description{
  Generates an object of class \code{"EuclRandVariable"}.
}
\usage{
EuclRandVariable(Map = list(function(x){1}), Domain = NULL, 
                 dimension = 1, Range)
}
\arguments{
  \item{Map}{ list of functions forming the map. }
  \item{Domain}{ object of class \code{"OptionalrSpace"}: 
    domain of \code{Map} }
  \item{dimension}{ positive integer: dimension of the 
    range of \code{Map} }
  \item{Range}{ object of class \code{"OptionalrSpace"}: 
    range of \code{Map} }
}
%\details{}
\value{Object of class \code{"EuclRandVariable"}}
%\references{}
\author{Matthias Kohl \email{Matthias.Kohl@stamats.de}}
%\note{}
\seealso{\code{\link{EuclRandVariable-class}}}
\examples{
L1 <- list(function(x){x}, function(x){x^2}, function(x){x^3}, function(x){x^4})
L2 <- list(function(x){exp(x)}, function(x){abs(x)}, 
           function(x){sin(x)}, function(x){floor(x)})

R1 <- EuclRandVariable(Map = L1, Domain = Reals(), dimension = 1)
Map(R1)
Range(R1)
Range(R1) <- Reals()
R1[2]
Map(R1[3])
Map(R1[c(1,2,4)])
Map(R1[2:4])
set.seed(123)
evalRandVar(R1, rnorm(1))
x <- as.matrix(rnorm(10))
res.R1 <- evalRandVar(R1, x)
res.R1[2,,] # results for Map(R1)[[2]](x)
res.R1[2,1,] # results for Map(R1)[[2]](x[1,])

R2 <- EuclRandVariable(L2, Domain = Reals(), dimension = 1)
DL1 <- imageDistr(R2, Norm())
plot(DL1)

Domain(R2) <- EuclideanSpace(dimension = 2)
Range(R2) <- EuclideanSpace(dimension = 2)
(X <- matrix(c(x, rnorm(10)), ncol = 2))
res.R2 <- evalRandVar(R2, X)
res.R2[3,,1] # results for Map(R2)[[3]](X[,1])

Map(log(abs(R2))) # "Math" group generic

# "Arith" group generic
Map(3 + R1)
Map(c(1,3,5) * R1)
try(1:5 * R1) # error
Map(1:2 * R2)
Map(R2 - 5)
Map(R1 ^ R1)


## The function is currently defined as
function(Map = list(function(x){1}), Domain = NULL, dimension = 1, Range) {
    if(missing(Range))
        return(new("EuclRandVariable", Map = Map, Domain = Domain, 
                   Range = EuclideanSpace(dimension = dimension)))
    else
        return(new("EuclRandVariable", Map = Map, Domain = Domain, 
                   Range = Range))
}
}
\concept{random variable}
\keyword{classes}
