% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-normal-walk.R
\name{random_normal_walk}
\alias{random_normal_walk}
\title{Generate Multiple Random Normal Walks}
\usage{
random_normal_walk(
  .num_walks = 25,
  .n = 100,
  .mu = 0,
  .sd = 0.1,
  .initial_value = 0,
  .samp = TRUE,
  .replace = TRUE,
  .sample_size = 0.8
)
}
\arguments{
\item{.num_walks}{An integer specifying the number of random walks to generate. Default is 25.}

\item{.n}{An integer specifying the number of steps in each walk. Default is 100.}

\item{.mu}{A numeric value indicating the mean of the normal distribution. Default is 0.}

\item{.sd}{A numeric value indicating the standard deviation of the normal distribution. Default is 0.1.}

\item{.initial_value}{A numeric value indicating the initial value of the walks. Default is 0.}

\item{.samp}{A logical value indicating whether to sample the normal distribution values. Default is TRUE.}

\item{.replace}{A logical value indicating whether sampling is with replacement. Default is TRUE.}

\item{.sample_size}{A numeric value between 0 and 1 specifying the proportion of \code{.n} to sample. Default is 0.8.}
}
\value{
A tibble containing the generated random walks with the following columns:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{x}: Step index.
\item \code{y}: Normal distribution values.
\item \code{cum_sum}: Cumulative sum of \code{y}.
\item \code{cum_prod}: Cumulative product of \code{y}.
\item \code{cum_min}: Cumulative minimum of \code{y}.
\item \code{cum_max}: Cumulative maximum of \code{y}.
}
The tibble includes attributes for the function parameters.
}
\description{
The \code{random_normal_walk} function is useful for simulating random processes
and can be applied in various fields such as finance, physics, and biology
to model different stochastic behaviors.
}
\details{
This function generates multiple random walks, which are sequences of steps
where each step is a random draw from a normal distribution. The user can
specify the number of walks, the number of steps in each walk, and the
parameters of the normal distribution (mean and standard deviation). The
function also allows for sampling a proportion of the steps and optionally
sampling with replacement.

The output tibble includes several computed columns for each walk, such as the
cumulative sum, product, minimum, and maximum of the steps.
}
\examples{
library(ggplot2)

# Generate 10 random walks with 50 steps each
set.seed(123)
random_normal_walk(.num_walks = 10, .n = 50)

# Generate random walks with different mean and standard deviation
set.seed(123)
random_normal_walk(.num_walks = 10, .n = 50, .samp = FALSE)

set.seed(123)
random_normal_walk(.num_walks = 2, .n = 100, .initial_value = 100) |>
  visualize_walks()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_normal_drift_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Generator Functions}
