% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt-visualize-walks.R
\name{visualize_walks}
\alias{visualize_walks}
\title{Visualize Walks}
\usage{
visualize_walks(.data, .alpha = 0.7, .interactive = FALSE, .pluck = FALSE)
}
\arguments{
\item{.data}{The input data. Assumed to be created by one of the random walk
functions in the RandomWalker package, but can be any data frame or tibble
that contains columns \code{walk_number}, \code{x}, and one or more numeric columns
like \code{y}, \code{cum_sum}, \code{cum_prod}, \code{cum_min}, \code{cum_max} and \code{cum_mean}, for
instance.}

\item{.alpha}{The alpha value for all the line charts in the visualization.
Values range from 0 to 1. Default is 0.7.}

\item{.interactive}{A boolean value. TRUE if you want the patches to be
interactive. FALSE if you don't. Default is FALSE.}

\item{.pluck}{If you want to visualize only one of the You can choose one of
the values (\code{y}, \code{cum_sum}, \code{cum_prod}, \code{cum_min}, \code{cum_max}, \code{cum_mean}).
Default is FALSE.}
}
\value{
A patchwork composed of 1 or more patches
}
\description{
visualize_walks() visualizes the output of the random walk
functions in the RandomWalker package, resulting in one or more ggplot2 plots
put together in a patchwork composed of 1 or more patches.
}
\details{
visualize_walks() generates visualizations of the random walks
generated by the  random walk functions in the RandomWalker package. These
are the functions at the moment of writing:
\itemize{
\item brownian_motion()
\item discrete_walk()
\item geometric_brownian_motion()
\item random_normal_drift_walk()
\item random_normal_walk()
\item rw30()
}

It is possible there are more when you read this, but you can check the rest
of the documentation for the current situation.

The visualization function is meant to be easy to use. No parameters needed,
but you can set \code{.alpha} if the default value of 0.7 isn't to your
liking.

You can also choose whether you want the visualization to be interactive or
not by setting \code{.interactive} to TRUE. The function uses the \code{ggiraph}
package for making the patches interactive.

If you want to visualize only one of the attributes, you can choose use one of
these values (\code{y}, \code{cum_sum}, \code{cum_prod}, \code{cum_min}, \code{cum_max}, \code{cum_mean}) for
the \code{.pluck} parameter.
}
\examples{
# Generate random walks and visualize the result
set.seed(123)
rw30() |>
 visualize_walks()

# Set the alpha value to be other than the default 0.7
set.seed(123)
rw30() |>
 visualize_walks(.alpha = 0.5)

# Use the function with an input that has alternatives for y
set.seed(123)
random_normal_walk(.num_walks = 5, .initial_value = 100) |>
 visualize_walks()

# Use the function to create interactive visualizations
set.seed(123)
random_normal_walk(.num_walks = 5, .initial_value = 100) |>
 visualize_walks(.interactive = TRUE)

# Use .pluck to pick just one visualization
set.seed(123)
random_normal_walk(.num_walks = 5, .initial_value = 100) |>
 visualize_walks(.pluck = "cum_sum")

}
\author{
Antti Lennart Rask
}
\concept{Visualization Functions}
