% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapfunc.R
\name{sdY.est}
\alias{sdY.est}
\title{Estimate trait variance, internal function}
\usage{
sdY.est(vbeta, maf, n)
}
\arguments{
\item{vbeta}{vector of variance of coefficients}

\item{maf}{vector of MAF (same length as vbeta)}

\item{n}{sample size}
}
\value{
estimated standard deviation of Y
}
\description{
Estimate trait standard deviation given vectors of variance of coefficients,  MAF and sample size
}
\details{
Estimate is based on var(beta-hat) = var(Y) / (n * var(X))
var(X) = 2\emph{maf}(1-maf)
so we can estimate var(Y) by regressing n*var(X) against 1/var(beta)
This function is verbatim from its namesake in coloc package (github.com/chr1swallace/coloc/), by Chris Wallace
}
\author{
Chris Wallace
}
