% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvt_flow.R
\name{rvn_rvt_flow}
\alias{rvn_rvt_flow}
\title{Write Raven rvt file from Flow Series}
\usage{
rvn_rvt_flow(
  flow.series,
  subID,
  stnName = NULL,
  rvt_type = "ObservationData",
  prd = NULL,
  write_redirect = FALSE,
  flip_number = FALSE,
  filename = NULL
)
}
\arguments{
\item{flow.series}{flows to write to file in xts format}

\item{subID}{subbasin ID corresponding to the flow series}

\item{stnName}{name of the station or file to write to file (used
to build rvt file name, required if filename not provided)}

\item{rvt_type}{type of flow-based rvt file to write, default ObservationData}

\item{prd}{period to use in writing rvt file, format "YYYY-MM-DD/YYYY-MM-DD"}

\item{write_redirect}{(optional) write the :RedirectToFile commands in a
separate .rvt file}

\item{flip_number}{(optional) put the subID first in the .rvt filename}

\item{filename}{specified name of file to write to (optional)}
}
\value{
\item{TRUE}{returns TRUE if the function executed successfully}
}
\description{
rvn_rvt_flow generates a Raven rvt file from a flow series
}
\details{
This function writes the rvt file for a given time series of
flows. The supplied flows should be in the xts format. This
function operates similarly to the ECflow.rvt function (
linked below).

prd is used by the xts formatted-data to restrict the data reported in .rvt
file to this period. The prd should be defined in
"YYYY-MM-DD/YYYY-MM-DD" string format. If the period supplied results in an
empty time series (i.e. non-overlapping time periods), an error will be
thrown.

write_redirect will print out the :RedirectToFile command in a separate
file called, "flow_stn_redirect_text.rvt". This command can be copied into
the main model's .rvt file to redirect to the produced time series files.

flip_number is a useful option to place the subID first in the filename.
This is often cleaner for organizing files in a folder, since the
alphabeticized order is not dependent on the station name, and the observed
files will be in one set.

The function will write to name generated from the station name, otherwise
the .rvt filename may be specified with the filename argument (full path to
the filename, including .rvt extension).
}
\examples{
# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)
obs <- rvn_hydrograph_data$hyd$Sub36_obs

# write out observation flow file to temporary file
rvn_rvt_flow(obs,subID=36,
  filename = file.path(tempdir(), "Nith_obs.rvt"))


}
\seealso{
\code{\link{rvn_rvt_wsc}} to create an rvt file from Water Survey Canada (WSC) data
}
