% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_csv_read.R
\name{rvn_csv_read}
\alias{rvn_csv_read}
\title{Read in generic Raven output csv files}
\usage{
rvn_csv_read(ff = NA, tzone = "UTC", xtsformat = TRUE)
}
\arguments{
\item{ff}{full file path to the csv file}

\item{tzone}{string indicating the timezone of the data in ff}

\item{xtsformat}{boolean whether to return in xts format (if date and/or hour found)}
}
\value{
data frame (as xts if set with \code{xtsformat}) read from the file
}
\description{
Reads in output csv files produced by Raven.
}
\details{
Expects a full file path to the Raven output file.

The timezone is provided by the tzone argument as "UTC" by default, and should be adjusted by
the user to the local time zone as needed, based on the model run.
}
\examples{
# create full file path
ff <- system.file("extdata","ReservoirStages.csv", package="RavenR")

# read in the Reservoir file with the generic call
myres <- rvn_csv_read(ff)

# view contents
head(myres)

}
\seealso{
\code{\link{rvn_hyd_read}} for reading Hydrographs output files
}
