% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscribe.R
\name{subscribe}
\alias{subscribe}
\title{Subscribe to streaming market data}
\usage{
subscribe(securities, fields, fun, options = NULL, identity = NULL,
  con = defaultConnection())
}
\arguments{
\item{securities}{A character vector with security symbols in
Bloomberg notation.}

\item{fields}{A character vector with Bloomberg query fields.}

\item{fun}{An R function to be called on the subscription data.}

\item{options}{An optional named character vector with option
values. Each field must have both a name (designating the option
being set) as well as a value.}

\item{identity}{An optional identity object.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
This function always returns NULL.
}
\description{
This function uses the Bloomberg API to stream live market data
}
\details{
The subscribe function allows one to subscribe to streaming market
quotes.

Full detials of the subscription string can be found in the header
file
\href{http://bloomberg.github.io/blpapi-docs/cpp/3.8/blpapi__subscriptionlist_8h.html}{blpapi_subscriptionlist.h}.
}
\examples{
\dontrun{
  subscribe(securities=c("TYZ5 Comdty","/cusip/912810RE0@BGN"),
            fields=c("LAST_PRICE","BID","ASK"),
            fun=function(x) print(str(x$data)))
}
}
\author{
Whit Armstrong
}
\references{
\url{http://bloomberg.github.io/blpapi-docs/cpp/3.8}
}

