% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{loadClusteringSample}
\alias{loadClusteringSample}
\title{Clustering loading}
\usage{
loadClusteringSample(filename.csv, data.sample, noise.cluster = "Noise")
}
\arguments{
\item{filename.csv}{character vector specifying the path and the name of the csv file containing the clustering result.}

\item{data.sample}{matrix of raw data (point by line).}

\item{noise.cluster}{character name of the cluster "Noise".}
}
\value{
The function returns a list 'clustering' containing:
\item{label}{vector of labels.}
\item{summary}{data.frame containing clusters summaries (min, max, sum, average, sd).}
\item{K}{number of clusters.}
}
\description{
Load a clustering result from a csv file into a data.sample object.
}
\details{
loadClusteringSample loads a clustering result from a csv file into data.sample object
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")
x <- importSample(file.features=tf1, dir.save=tempdir())

lab <- data.frame(ID=1:nrow(dat), label=c(rep("Cluster 1",50), rep("Cluster 2",50), 
                                          rep("Cluster 3",50)))
tf2 <- tempfile()
write.table(lab, tf2, sep=",")

loadClusteringSample(tf2, x)

}
\seealso{
\code{\link{saveClustering}}
}
\keyword{internal}
