% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computeItemsSampleGUI}
\alias{computeItemsSampleGUI}
\title{GUI to estimate the number of cells in colonies for each cluster}
\usage{
computeItemsSampleGUI(
  data.sample,
  method.select = "K-means",
  RclusTool.env = initParameters()
)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{method.select}{character vector specifying the name of the clustering result to use ('K-means' by default).}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}
}
\value{
data.sample with saved count results

csv file containing the counts.
}
\description{
Open a Graphical User Interface allowing to choose cluster name and model file for the estimation and the saving of the number of cells in colonies.
}
\details{
computeItemsSampleGUI opens a Graphical User Interface allowing to choose cluster name and model file for the estimation and the saving of the number of cells in colonies
}
\examples{
\donttest{ 

dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf)

x <- computeUnSupervised(x, K=0, pca=TRUE, echo=TRUE)
computeItemsSampleGUI(x, method.select="K-means")
 
}
}
\keyword{internal}
