% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computeKmeans}
\alias{computeKmeans}
\title{K-means clustering}
\usage{
computeKmeans(x, K = 0, K.max = 20, kmeans.variance.min = 0.95,
  graph = F)
}
\arguments{
\item{x}{matrix of raw data (point by line).}

\item{K}{number of clusters. If K=0 (default), this number is automatically computed thanks to the Elbow method.}

\item{K.max}{maximal number of clusters (K.Max=20 by default).}

\item{kmeans.variance.min}{elbow method cumulative explained variance > criteria to stop K-search.}

\item{graph}{boolean: if TRUE, figures for total of within-class inertia and explained variance are plotted.}
}
\value{
res.kmeans results obtained from kmeans algorithm.
}
\description{
Perform K-means clustering, dealing with the number of clusters K, automatically or not.
}
\details{
computeKmeans performs K-means clustering, dealing with the number of clusters K, automatically or not
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=tempdir())
res.kmeans <- computeKmeans(x$features$initial$x, K=0, graph=TRUE)
plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
col = res.kmeans$cluster, main = "K-means clustering")



}
\seealso{
\code{\link{computeUnSupervised}}, \code{\link{computeEM}}
}
\keyword{internal}
