% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Compadre}
\alias{Compadre}
\alias{Comadre}
\title{Subsamples of the COMPADRE Plant Matrix Database and COMADRE Animal
Matrix Database for testing and examples}
\format{
Slot \strong{data} - A tibble-style data frame with the following 48 columns:
\itemize{
\item mat - A list of 'CompadreMat' objects, each with the following slots:
\itemize{
\item matA - A matrix population model
\item matU - The survival- and growth-related component of matA
\item matF - The sexual reproduction component of matA
\item matC - The clonal reproduction component of matA
\item matrixClass - A data frame with the following columns:
\itemize{
\item MatrixClassOrganized - Standardized stage class of the matrix
population model
\item MatrixClassAuthor - Stage description from the original publication
\item MatrixClassNumber - Integer stage number
}
}
\item SpeciesAuthor - Binomial species name given by the paper's author
\item SpeciesAccepted - Accepted binomial species name taken from \emph{The Plant
List} or \emph{Catalogue of Life}
\item CommonName - Common name for species used in the publication
\item Genus - Taxonomic genus that the accepted species belongs to
\item Family - Family that the species belongs to
\item Order - Order that the species belongs to
\item Class - Class that the species belongs to
\item Phylum - Phylum that the species belongs to
\item Kingdom - Kingdom that the species belongs to
\item OrganismType - Organism type (see COMPADRE User Guide for documentation)
\item DicotMonoc - Whether the species is a dicot or monocot. Non-angiosperms are
\code{NA}.
\item AngioGymno - Whether the species is an angiosperm or gymnosperm. Non-plants
are \code{NA}.
\item Authors - Last name of all authors (separated with ";")
\item Journal - Abbreviated journal title, or type of source document (e.g. "PhD
thesis")
\item YearPublication - Year of publication
\item DOI.ISBN - Digital Object Identifier or International Standard Book Number
codes to identify each publication
\item AdditionalSource - Additional source(s) used to reconstruct the matrix or
obtain additional metadata for the matrix (if applicable)
\item StudyDuration - Number of years of observation in study (\code{StudyEnd - StudyStart})
\item StudyStart - Study start year
\item StudyEnd - Study end year
\item AnnualPeriodicity - Inverse of the length of the projection interval (in
years)
\item NumberPopulations - The number of study populations as defined by the
authors. Within site replication of permanent plots is not defined as
separate populations
\item MatrixCriteriaSize - Indicates whether the matrix contains stages based on
size. If so, indicates what that measure of size is
\item MatrixCriteriaOntogeny - Indicates whether the matrix contains stages based
on ontogenic/developmental stages
\item MatrixCriteriaAge - Indicates whether the matrix contains stages based on
age
\item MatrixPopulation - Population name or definition of where the matrix was
recorded, usually given by the author. See COMPADRE User Guide.
\item Lat - Latitude in decimal degrees
\item Lon - Longitude in decimal degrees
\item Altitude - Altitude of study site (m above sea level)
\item Country - 3-letter ISO country code for the country in which the study took
place (multiple countries separated with ";")
\item Continent - Continent on which study took place
\item Ecoregion - Ecoregion in which study took place. See COMPADRE User Guide.
\item StudiedSex - Whether study included only males ("M"), only females ("F"),
or both sexes ("M/F")
\item MatrixComposite - Indicates the type of matrix population model. Possible
values are \code{Individual}, \code{Mean}, \code{Pooled}, and \code{Seasonal}. See COMPADRE
User Guide.
\item MatrixTreatment - Describes if a treatment was applied to the population or
not. If yes, includes a brief description of the treatment. If not,
\code{Unmanipulated}
\item MatrixCaptivity - Whether species was studied in the wild (\code{W}), captivity
(\code{C}), or captured from a wild population (\code{CW})
\item MatrixStartYear - First year of matrix
\item MatrixStartSeason - First season of matrix as described by author
(hemisphere-specific)
\item MatrixStartMonth - First month of matrix
\item MatrixEndYear - Final year of matrix
\item MatrixEndSeason - Final season of matrix as described by author
(hemisphere-specific)
\item MatrixEndMonth - Final month of matrix
\item MatrixSplit - Whether the \strong{A} matrix has been split into components
\strong{U}, \strong{F}, and \strong{C} ("Divided") or not ("Indivisible"). If not,
elements of \code{matU}, \code{matF}, and \code{matC} are filled with \code{NA}
\item MatrixFec - Whether fecundity was measured for the matrix model
\item Observation - Additional observations recorded by database compilers
\item MatrixDimension - Dimension of the \strong{A} matrix
\item SurvivalIssue - Denotes the maximum stage-specific survival value
\cr
}

Slot \strong{version} - A list with the following elements:
\itemize{
\item Version - The version number of the database
\item DateCreated - The date that the \code{.RData} file was created
\item Agreement - Link to the COMADRE license agreement
}

An object of class \code{CompadreDB} with 150 rows and 49 columns.

An object of class \code{CompadreDB} with 150 rows and 49 columns.
}
\usage{
Compadre

Comadre
}
\description{
\code{Compadre} (plant matrices) and \code{Comadre} (animal matrices) are subsamples of
the COMPADRE Plant Matrix Database and COMADRE Animal Matrix Database,
respectively, that are used for testing and examples. Each object is of class
'CompadreDB' and therefore has the following two slots: \code{data} and \code{version}.

For full documentation see the \href{https://jonesor.github.io/CompadreGuides/}{COMPADRE User Guide}.
}
\keyword{datasets}
