# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

fastLm <- function(X, y) {
    .Call('RcppArmadillo_fastLm', PACKAGE = 'RcppArmadillo', X, y)
}

#' Report the version of Armadillo 
#' 
#' @details The version is defined by Armadillo in the header \code{arma_version.hpp}.
#' @param single A logical vector indicating whether a single return values is requested,
#' or a named vector with three elements \code{major}, \code{minor} and \code{patch}.
#' @return Depending on the value of \code{single}, either a single number describing the Armadillo version
#' or a named vector with three elements \code{major}, \code{minor} and \code{patch}.
#' @seealso Armadillo header file \code{arma_version.hpp}.
armadillo_version <- function(single) {
    .Call('RcppArmadillo_armadillo_version', PACKAGE = 'RcppArmadillo', single)
}

#' Set the Armadillo Random Number Generator to a random value
#' 
#' @details Depending on whether RcppArmadillo was compiled for the C++98 standard 
#' (currently the default) or for C++11 (optional), two different RNGs may be used. 
#' This function resets either. For C++98, the system library RNG is used. It may
#' have poor performance, particularly on older versions of Windows. For C++11, the
#' RNG included in its library is used.
#' @return The function is invoked for its side effect and has no return value.
#' @note This has been found to not work as espected in \pkg{RStudio}
#' as its code also uses the system RNG library. You may have to either
#' not run within \pkg{RStudio} or change your code to use a different RNG such 
#' as the one from R.
#' @seealso The R documentation on its RNGs all of which are accessible via \pkg{Rcpp}.  
armadillo_set_seed_random <- function() {
    invisible(.Call('RcppArmadillo_armadillo_set_seed_random', PACKAGE = 'RcppArmadillo'))
}

#' Set the Armadillo Random Number Generator to the given value
#' 
#' @param val The seed used to initialize Armadillo's random number generator.
#' @details Depending on whether RcppArmadillo was compiled for the C++98 standard 
#' (currently the default) or for C++11 (optional), two different RNGs may be used. 
#' This function resets either. For C++98, the system library RNG is used. It may
#' have poor performance, particularly on older versions of Windows. For C++11, the
#' RNG included in its library is used.
#' @return The function is invoked for its side effect and has no return value. 
#' @note This has been found to not work as espected in \pkg{RStudio}
#' as its code also uses the system RNG library. You may have to either
#' not run within \pkg{RStudio} or change your code to use a different RNG such 
#' as the one from R.
#' @seealso The R documentation on its RNGs all of which are accessible via \pkg{Rcpp}.  
armadillo_set_seed <- function(val) {
    invisible(.Call('RcppArmadillo_armadillo_set_seed', PACKAGE = 'RcppArmadillo', val))
}

