//=================================================================================================
/*!
//  \file blaze/math/SparseVector.h
//  \brief Header file for all basic SparseVector functionality
//
//  Copyright (C) 2013 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_MATH_SPARSEVECTOR_H_
#define _BLAZE_MATH_SPARSEVECTOR_H_


//*************************************************************************************************
// Includes
//*************************************************************************************************

#include <blaze/math/expressions/DenseVector.h>
#include <blaze/math/expressions/DVecSVecMultExpr.h>
#include <blaze/math/expressions/SparseVector.h>
#include <blaze/math/expressions/SVecAbsExpr.h>
#include <blaze/math/expressions/SVecConjExpr.h>
#include <blaze/math/expressions/SVecDVecMultExpr.h>
#include <blaze/math/expressions/SVecEvalExpr.h>
#include <blaze/math/expressions/SVecImagExpr.h>
#include <blaze/math/expressions/SVecRealExpr.h>
#include <blaze/math/expressions/SVecScalarDivExpr.h>
#include <blaze/math/expressions/SVecScalarMultExpr.h>
#include <blaze/math/expressions/SVecSerialExpr.h>
#include <blaze/math/expressions/SVecSVecAddExpr.h>
#include <blaze/math/expressions/SVecSVecMultExpr.h>
#include <blaze/math/expressions/SVecSVecSubExpr.h>
#include <blaze/math/expressions/SVecTransExpr.h>
#include <blaze/math/expressions/TDVecSVecMultExpr.h>
#include <blaze/math/expressions/TSVecSVecMultExpr.h>
#include <blaze/math/expressions/TSVecDVecMultExpr.h>
#include <blaze/math/smp/DenseVector.h>
#include <blaze/math/smp/SparseVector.h>
#include <blaze/math/sparse/SparseVector.h>
#include <blaze/math/Vector.h>

#endif
