// Copyright (c) 2014 INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
//
// $URL: https://github.com/CGAL/cgal/blob/v6.0.1/Barycentric_coordinates_2/include/CGAL/Barycentric_coordinates_2.h $
// $Id: include/CGAL/Barycentric_coordinates_2.h 50cfbde3b84 $
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s)     : Dmitry Anisimov, David Bommes, Kai Hormann, Pierre Alliez
//

#ifndef CGAL_BARYCENTRIC_COORDINATES_2_H
#define CGAL_BARYCENTRIC_COORDINATES_2_H

/// \cond SKIP_IN_MANUAL
#include <CGAL/license/Barycentric_coordinates_2.h>
/// \endcond

/**
* \ingroup PkgBarycentricCoordinates2Ref
* \file CGAL/Barycentric_coordinates_2.h
* A convenience header that includes all free functions and classes for
* 2D barycentric coordinates in closed form. Harmonic coordinates are not included.
*/

// Internal includes.
#include <CGAL/Barycentric_coordinates_2/barycentric_enum_2.h>
#include <CGAL/Barycentric_coordinates_2/segment_coordinates_2.h>
#include <CGAL/Barycentric_coordinates_2/triangle_coordinates_2.h>
#include <CGAL/Barycentric_coordinates_2/boundary_coordinates_2.h>

#include <CGAL/Barycentric_coordinates_2/Wachspress_coordinates_2.h>
#include <CGAL/Barycentric_coordinates_2/Discrete_harmonic_coordinates_2.h>
#include <CGAL/Barycentric_coordinates_2/Mean_value_coordinates_2.h>

#include <CGAL/Barycentric_coordinates_2/Wachspress_2.h>
#include <CGAL/Barycentric_coordinates_2/Discrete_harmonic_2.h>
#include <CGAL/Barycentric_coordinates_2/Generalized_barycentric_coordinates_2.h>
#include <CGAL/Barycentric_coordinates_2/Mean_value_2.h>

#endif // CGAL_BARYCENTRIC_COORDINATES_2_H

