% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HISTORY.R
\docType{data}
\name{HISTORY}
\alias{HISTORY}
\title{Sample history substitution table from SNOMED CT dictionary}
\format{
An object of class \code{"data.table"}
}
\usage{
data(HISTORY)
}
\description{
Sample of the SNOMED CT table showing current equivalents for inactive concepts.
}
\details{
\itemize{
  \item{OLDCONCEPTID}{ integer64: concept ID of the inactive concepts} 
  \item{OLDCONCEPTSTATUS}{ integer: status of the old concept} 
  \item{NEWCONCEPTID}{ integer64: concept ID of the new concept}
  \item{NEWCONCEPTSTATUS}{ integer: status of the new concept} 
  \item{PATH}{ character: path} 
  \item{ISAMBIGUOUS }{ integer: whether ambiguous} 
  \item{ITERATIONS}{ integer: number of iterations} 
  \item{OLDCONCEPTFSN}{ character: old concept Fully Specified Name}
  \item{OLDCONCEPTFSN_TAGCOUNT}{ integer: number of tags for old concept}
  \item{NEWCONCEPTFSN}{ integer: new concept Fully Specified Name}
  \item{NEWCONCEPTFSN_STATUS}{ integer: new concept Fully Specified Name status}
  \item{TLH_IDENTICALFLAG}{ integer: whether TLH identical}
  \item{FSN_TAGLESSIDENTICALFLAG}{ integer: whether Fully Specified Names are identical ignoring the tags}
  \item{FSN_TAGIDENTICALFLAG}{ integer: whether Fully Specified Names tags are identical}
}
}
\examples{
# Create a TEST environment and load the sample dictionaries
TEST <- new.env()
data(CONCEPT, envir = TEST)
data(DESCRIPTION, envir = TEST)
data(RELATIONSHIP, envir = TEST)
data(STATEDRELATIONSHIP, envir = TEST)
data(HISTORY, envir = TEST)

# Show properties of the history table
str(TEST$HISTORY)
}
\seealso{
Other SNOMEDsample: 
\code{\link{QUERY}},
\code{\link{SNOMED_RELATIONSHIP}}
}
\concept{SNOMEDsample}
\keyword{datasets}
