% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_CCA.R
\name{do.cca}
\alias{do.cca}
\title{Canonical Correlation Analysis}
\usage{
do.cca(data1, data2, ndim = 2)
}
\arguments{
\item{data1}{an \eqn{(n\times N)} data matrix whose rows are observations}

\item{data2}{an \eqn{(n\times M)} data matrix whose rows are observations}

\item{ndim}{an integer-valued target dimension.}
}
\value{
a named list containing
\describe{
\item{Y1}{an \eqn{(n\times ndim)} matrix of projected observations from \code{data1}.}
\item{Y2}{an \eqn{(n\times ndim)} matrix of projected observations from \code{data2}.}
\item{projection1}{a \eqn{(N\times ndim)} whose columns are loadings for \code{data1}.}
\item{projection2}{a \eqn{(M\times ndim)} whose columns are loadings for \code{data2}.}
\item{trfinfo1}{a list containing information for out-of-sample prediction for \code{data1}.}
\item{trfinfo2}{a list containing information for out-of-sample prediction for \code{data2}.}
\item{eigvals}{a vector of eigenvalues for iterative decomposition.}
}
}
\description{
Canonical Correlation Analysis (CCA) is similar to Partial Least Squares (PLS), except for one objective; while PLS focuses
on maximizing covariance, CCA maximizes the correlation. This difference sometimes incurs quite distinct results compared to PLS.
For algorithm aspects, we used recursive gram-schmidt orthogonalization in conjunction with extracting projection vectors under
eigen-decomposition formulation, as the problem dimension matters only up to original dimensionality.
For more details, see \href{https://en.wikipedia.org/wiki/Canonical_correlation}{Wikipedia entry} on Canonical Correlation.
}
\examples{
## generate 2 normal data matrices
mat1 = matrix(rnorm(100*12),nrow=100)+10 # 12-dim normal
mat2 = matrix(rnorm(100*6), nrow=100)-10 # 6-dim normal

## project onto 2 dimensional space for each data
output = do.cca(mat1, mat2, ndim=2)

## visualize
par(mfrow=c(1,2))
plot(output$Y1[,1], output$Y1[,2], main="proj(mat1)")
plot(output$Y2[,1], output$Y2[,2], main="proj(mat2)")

}
\references{
\insertRef{hotelling_relations_1936}{Rdimtools}
}
\seealso{
\code{\link{do.pls}}
}
\author{
Kisung You
}
