% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KQMI.R
\name{do.kqmi}
\alias{do.kqmi}
\title{Kernel Quadratic Mutual Information}
\usage{
do.kqmi(X, label, ndim = 2, preprocess = c("center", "scale", "cscale",
  "whiten", "decorrelate"), t = 10)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{t}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Kernel Quadratic Mutual Information (KQMI) is a supervised linear dimension reduction method.
Quadratic Mutual Information is an efficient nonparametric estimation method for Mutual Information
for class labels not requiring class priors. The method re-states the estimation procedure in terms of
kernel objective in the graph embedding framework.
}
\examples{
\dontrun{
## generate 3 different groups of data X and label vector
x1 = matrix(rnorm(4*10), nrow=10)-20
x2 = matrix(rnorm(4*10), nrow=10)
x3 = matrix(rnorm(4*10), nrow=10)+20
X  = rbind(x1, x2, x3)
label = c(rep(1,10), rep(2,10), rep(3,10))

## try different kernel bandwidths
out1 = do.kqmi(X, label, t=0.01)
out2 = do.kqmi(X, label, t=1)
out3 = do.kqmi(X, label, t=100)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="KQMI::t=0.01")
plot(out2$Y[,1], out2$Y[,2], main="KQMI::t=1")
plot(out3$Y[,1], out3$Y[,2], main="KQMI::t=100")
}

}
\references{
\insertRef{bouzas_graph_2015}{Rdimtools}
}
\seealso{
\code{\link{do.lqmi}}
}
\author{
Kisung You
}
