% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_SNE.R
\name{do.sne}
\alias{do.sne}
\title{Stochastic Neighbor Embedding}
\usage{
do.sne(X, ndim = 2, perplexity = 30, eta = 0.05, maxiter = 2000,
  jitter = 0.3, jitterdecay = 0.99, momentum = 0.5,
  preprocess = c("null", "center", "scale", "scale", "decorrelate",
  "whiten"), pca = TRUE, pcaratio = 0.9, pcascale = FALSE,
  symmetric = FALSE)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{perplexity}{desired level of perplexity; ranging [5,50].}

\item{eta}{learning parameter.}

\item{maxiter}{maximum number of iterations.}

\item{jitter}{level of white noise added at the beginning.}

\item{jitterdecay}{decay parameter in \eqn{(0,1)}. The closer to 0, the faster artificial noise decays.}

\item{momentum}{level of acceleration in learning.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{pca}{whether to use PCA as preliminary step; \code{TRUE} for using it, \code{FALSE} otherwise.}

\item{pcaratio}{proportion of variances explained in finding PCA preconditioning. See also \code{\link{do.pca}} for more details.}

\item{pcascale}{a logical; \code{FALSE} for using Covariance, \code{TRUE} for using Correlation matrix. See also \code{\link{do.pca}} for more details.}

\item{symmetric}{a logical; \code{FALSE} to solve it naively, and \code{TRUE} to adopt symmetrization scheme.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{vars}{a vector containing betas used in perplexity matching.}
}
}
\description{
Stochastic Neighbor Embedding (SNE) is a probabilistic approach to mimick distributional
description in high-dimensional - possible, nonlinear - subspace on low-dimensional target space.
\code{do.sne} fully adopts algorithm details in an original paper by Hinton and Roweis (2002).
}
\examples{
\dontrun{
## generate ribbon-shaped data
## in order to pass CRAN pretest, n is set to be small.
X = aux.gensamples(dname="ribbon",n=99)

## 1. pca scaling with 90\% variances explained
output1 <- do.sne(X,ndim=2,pca=TRUE)

## 2. pca scaling wiht 50\% variances explained
output2 <- do.sne(X,ndim=2,pca=TRUE,pcaratio=0.50)

## 3. Setting 2 + smaller level of perplexity
output3 <- do.sne(X,ndim=2,pca=TRUE,pcaratio=0.50,perplexity=10)

## Visualize three different projections
par(mfrow=c(1,3))
if ((length(output1)!=1)&&(!is.na(output1))){plot(output1$Y[,1],output1$Y[,2],main="Setting 1")}
if ((length(output1)!=1)&&(!is.na(output2))){plot(output2$Y[,1],output2$Y[,2],main="Setting 2")}
if ((length(output1)!=1)&&(!is.na(output3))){plot(output3$Y[,1],output3$Y[,2],main="Setting 3")}
}

}
\references{
\insertRef{hinton_stochastic_2003}{Rdimtools}
}
\author{
Kisung You
}
