% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_NONPP.R
\name{do.nonpp}
\alias{do.nonpp}
\title{Nonnegative Orthogonal Neighborhood Preserving Projections}
\usage{
do.nonpp(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("null", "center", "decorrelate", "whiten"),
  maxiter = 1000,
  reltol = 1e-05
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{number of maximum iteraions allowed.}

\item{reltol}{stopping criterion for incremental relative error.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Nonnegative Orthogonal Neighborhood Preserving Projections (NONPP) is a variant of ONPP where
projection vectors - or, basis for learned subspace - contain no negative values.
}
\examples{
\dontrun{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])+50
label = as.integer(iris$Species)

## use different levels of connectivity
out1 = do.nonpp(X, type=c("proportion",0.1))
out2 = do.nonpp(X, type=c("proportion",0.2))
out3 = do.nonpp(X, type=c("proportion",0.5))

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="NONPP::10\% connected")
plot(out2$Y, col=label, main="NONPP::20\% connected")
plot(out3$Y, col=label, main="NONPP::50\% connected")
par(opar)
}

}
\references{
\insertRef{zafeiriou_nonnegative_2010}{Rdimtools}
}
\seealso{
\code{\link{do.onpp}}
}
\author{
Kisung You
}
