% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_PFLPP.R
\name{do.pflpp}
\alias{do.pflpp}
\title{Parameter-Free Locality Preserving Projection}
\usage{
do.pflpp(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Conventional LPP is known to suffer from sensitivity upon choice of parameters, especially
in building neighborhood information. Parameter-Free LPP (PFLPP) takes an alternative step
to use normalized Pearson correlation, taking an average of such similarity as a threshold
to decide which points are neighbors of a given datum.
}
\examples{
## generate swiss roll data
X = aux.gensamples(n=200)

## compare with PCA
out1 = do.pca(X, ndim=2)
out2 = do.pflpp(X, ndim=2)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(out1$Y, main="PCA")
plot(out2$Y, main="Parameter-Free LPP")
par(opar)

}
\references{
\insertRef{dornaika_enhanced_2013}{Rdimtools}
}
\author{
Kisung You
}
