% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ver2_nonlinear_PHATE.R
\name{do.phate}
\alias{do.phate}
\title{Potential of Heat Diffusion for Affinity-based Transition Embedding}
\usage{
do.phate(
  X,
  ndim = 2,
  k = 5,
  alpha = 10,
  dtype = c("log", "sqrt"),
  smacof = TRUE,
  maxiter = 100,
  abstol = 1e-06
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{k}{size of nearest neighborhood (default: 5).}

\item{alpha}{decay parameter for Gaussian kernel exponent (default: 10).}

\item{dtype}{type of potential distance transformation; \code{"log"} or \code{"sqrt"}.}

\item{smacof}{a logical; \code{TRUE} to use SMACOF for Metric MDS (default), or \code{FALSE} to use Classical MDS.}

\item{maxiter}{maximum number of iterations for metric MDS updates (default: 100).}

\item{abstol}{stopping criterion for metric MDS iterations (default: 1e-6).}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
PHATE is a nonlinear method that is specifically targeted at visualizing
high-dimensional data by embedding it on 2- or 3-dimensional space. We offer
a native implementation of PHATE solely in R/C++ without interface to python module.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## compare two potential distances with PCA
pca2d <- do.pca(X, ndim=2)
phlog <- do.phate(X, ndim=2, dtype="log")
phsqt <- do.phate(X, ndim=2, dtype="sqrt")

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(pca2d$Y, col=lab, pch=19, main="PCA")
plot(phlog$Y, col=lab, pch=19, main="log potential")
plot(phsqt$Y, col=lab, pch=19, main="sqrt potential")
par(opar)
}

}
\references{
\insertRef{moon_visualizing_2019}{Rdimtools}
}
\concept{nonlinear_methods}
