% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_linear_ASI.R
\name{do.asi}
\alias{do.asi}
\title{Adaptive Subspace Iteration}
\usage{
do.asi(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 100).}
\item{abstol}{absolute tolerance stopping criterion (default: 1e-8).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Adaptive Subspace Iteration (ASI) iteratively finds the best subspace to perform data clustering. It can be regarded as
one of remedies for clustering in high dimensional space. Eigenvectors of a within-cluster scatter matrix are used
as basis of projection.
}
\examples{
\donttest{
## use iris data
data(iris, package="Rdimtools")
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## compare ASI with other methods
outASI = do.asi(X)
outPCA = do.pca(X)
outLDA = do.lda(X, label)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(outASI$Y, pch=19, col=label, main="ASI")
plot(outPCA$Y, pch=19, col=label, main="PCA")
plot(outLDA$Y, pch=19, col=label, main="LDA")
par(opar)
}

}
\references{
\insertRef{li_document_2004}{Rdimtools}
}
\seealso{
\code{\link{do.ldakm}}
}
\author{
Kisung You
}
\concept{linear_methods}
