% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_nonlinear_DPPCA.R
\name{do.dppca}
\alias{do.dppca}
\title{Dual Probabilistic Principal Component Analysis}
\usage{
do.dppca(X, ndim = 2, beta = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{beta}{the degree for modeling the level of noise (default: 1).}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Dual view of PPCA optimizes the latent variables directly from a simple
Bayesian approach to model the noise using the multivariate Gaussian distribution
of zero mean and spherical covariance \eqn{\beta^{-1} I}. When \eqn{\beta} is too small,
the algorithm automatically returns an error and provides a guideline for minimal
value that enables successful computation.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## compare difference choices of 'beta'
embed1 <- do.dppca(X, beta=0.2)
embed2 <- do.dppca(X, beta=1)
embed3 <- do.dppca(X, beta=5)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
plot(embed1$Y , col=lab, pch=19, main="beta=0.2")
plot(embed2$Y , col=lab, pch=19, main="beta=1")
plot(embed3$Y , col=lab, pch=19, main="beta=5")
par(opar)
}

}
\references{
\insertRef{lawrence_probabilistic_2005}{Rdimtools}
}
\seealso{
\code{\link{do.ppca}}
}
\concept{nonlinear_methods}
