% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.abund.R
\name{print.abund}
\alias{print.abund}
\title{Print abundance estimates}
\usage{
\method{print}{abund}(x, criterion = "AICc", ...)
}
\arguments{
\item{x}{An object output by \code{abundEstim}.  This is a distance function object that 
also contains abundance estimates, and has class \code{c("abund", "dfunc")}.}

\item{criterion}{A string specifying the criterion to print.
Must be one of "AICc" (the default), 
"AIC", or "BIC".  See \code{\link{AIC.dfunc}} for formulas.}

\item{\dots}{Included for compatibility to other print methods.  Ignored here.}
}
\value{
No value is returned.
}
\description{
Print an object of class \code{c("abund","dfunc")} 
that is output by \code{abundEstim}.
}
\details{
The default print method for class 'dfunc' is called, then the abundance estimates 
  contained in \code{obj} are printed.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDetectionData)
data(sparrowSiteData)

# Fit half-normal detection function
dfunc <- dfuncEstim(formula=dist~1,
                    detectionData=sparrowDetectionData,
                    likelihood="halfnorm", w.hi=100, pointSurvey=FALSE)

# Estimate abundance given a detection function
# Note, area=10000 converts to density per hectare (for distances measured in meters)
# Note, a person should do more than R=20 iterations
fit <- abundEstim(dfunc, detectionData=sparrowDetectionData,
                  siteData=sparrowSiteData, area=10000, R=20, ci=0.95,
                  plot.bs=TRUE, bySite=FALSE)

# Print results
print(fit)
fit
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}
}
\author{
Trent McDonald, WEST Inc., \email{tmcdonald@west-inc.com}
}
\keyword{models}
