% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparrowSiteData.R
\docType{data}
\name{sparrowSiteData}
\alias{sparrowSiteData}
\title{Brewer's Sparrow site data}
\format{
A data.frame containing 72 rows and 8 columns.  Each row represents
a site (transect) surveyed.  Column descriptions: 

\enumerate{ 
  \item \code{siteID}: Factor (72 levels), the site or transect surveyed.  
  \item \code{length}: Number, the length (m) of each transect.  
  \item \code{observer}: Factor (five levels), identity of the observer 
  who surveyed the transect.
  \item \code{bare}: Number, the mean bare ground cover (\%) within 100 m of each transect.
  \item \code{herb}: Number, the mean herbaceous cover (\%) within 100 m of
  each transect.
  \item \code{shrub}: Number, the mean shrub cover (\%) within
  100 m of each transect.
  \item \code{height}: Number, the mean shrub height 
  (cm) within 100 m of each transect.
  \item \code{shrubclass}: Factor (two levels), shrub class is "Low"" when 
  shrub cover is < 10\%, "High" otherwise.  
}
}
\source{
The Brewer's sparrow data are a subset of the data collected 
by Jason Carlisle and various field technicians for his Ph.D. from the 
Department of Ecology, University of Wyoming, in 2017.  This portion of 
Jason's work was funded by the Wyoming Game and Fish Department through agreements 
with the University of Wyoming's  Cooperative Fish & Wildlife
Research Unit (2012).
}
\description{
Site data from line transect surveys for 
Brewer's sparrow on 72 transects 
located on a 4105 km^2 study 
area in central Wyoming. Data were collected by 
Dr. Jason Carlisle of the Wyoming Cooperative Fish & Wildlife
Research Unit in 2012. Each transect was 500 meters long.
See the package vignettes for tutorials of the basic analysis.
}
\references{
Carlisle, J.D. 2017. The effect of sage-grouse conservation on
wildlife species of concern: Implications for the umbrella species concept.
Dissertation. University of Wyoming, Laramie, Wyoming, USA.

Carlisle, J. D., and A. D. Chalfoun. 2020. The abundance of Greater 
Sage-Grouse as a proxy for the abundance of sagebrush-associated songbirds 
in Wyoming, USA. \emph{Avian Conservation and Ecology} 15(2):16. 
\doi{10.5751/ACE-01702-150216}
}
\seealso{
\code{\link{sparrowDetectionData}}
}
\keyword{datasets}
