% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.dfunc.r
\name{coef.dfunc}
\alias{coef.dfunc}
\title{coef.dfunc - Coefficients of an estimated detection function}
\usage{
\method{coef}{dfunc}(object, \dots)
}
\arguments{
\item{object}{An Rdistance model frame or fitted distance function,
normally produced by a call to \code{\link{dfuncEstim}}.}

\item{...}{Ignored}
}
\value{
The estimated coefficient vector for the detection function. 
Length and interpretation of values vary 
depending on the form of the detection function and expansion terms.
}
\description{
Extract distance model coefficients from 
an estimated detection function object.
}
\examples{
data(sparrowDfuncObserver) # pre-estimated dfunc

# Same as sparrowDfuncObserver$par 
coef(sparrowDfuncObserver) 

\dontrun{
data(sparrowDf)
dfunc <- sparrowDf |> dfuncEstim(dist~bare + observer,
                      w.hi=units::set_units(150, "m"))
coef(dfunc)
}
 
}
\seealso{
\code{\link{AIC}}, \code{\link{dfuncEstim}}
}
\keyword{model}
