/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleImpl;
import org.drools.core.util.TripleStore;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TripleBasedStruct;
import org.drools.runtime.rule.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleBasedTypes
extends TripleBasedStruct {
    protected Object object;

    public TripleBasedTypes(Object obj, TripleStore store) {
        this.store = store;
        this.object = obj;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public int size() {
        return this.getSchemaTriplesForSubject(this.getObject()).size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.store.contains(this.property("rdfs:type", key));
    }

    @Override
    public boolean containsValue(Object value) {
        for (Triple t : this.getSchemaTriplesForSubject(this.getObject())) {
            if (!t.getProperty().equals("rdfs:type")) continue;
            return this.store.contains(new TripleImpl(t.getValue(), "drools:proxy", value));
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Triple t = this.store.get(new TripleImpl(key, "drools:proxy", (Object)Variable.v));
        return t == null ? null : t.getValue();
    }

    @Override
    public Object put(String key, Object value) {
        this.store.put(new TripleImpl((Object)key, "drools:proxy", value));
        Boolean ret = this.store.add(this.property("rdfs:type", key));
        return ret;
    }

    @Override
    public Object remove(Object key) {
        Triple t = this.store.get(new TripleImpl(key, "drools:proxy", (Object)Variable.v));
        if (t == null) {
            return false;
        }
        this.store.remove(t);
        this.store.remove(this.property("rdfs:type", key));
        return t.getValue();
    }

    @Override
    public void clear() {
        for (Triple t : this.getSchemaTriplesForSubject(this.getObject())) {
            this.store.remove(t);
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (Triple t : this.getSchemaTriplesForSubject(this.getObject())) {
            if (!t.getProperty().equals("rdfs:type")) continue;
            set.add(t.getValue().toString());
        }
        return set;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Triple t : this.getSchemaTriplesForSubject(this.getObject())) {
            values.add(this.store.get(new TripleImpl(t.getValue(), "drools:proxy", null)).getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        for (Triple t : this.getSchemaTriplesForSubject(this.getObject())) {
            Triple proxy = this.store.get(new TripleImpl(t.getValue(), "drools:proxy", (Object)Variable.v));
            set.add(TraitProxy.buildEntry((String)t.getValue(), proxy.getValue()));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        Object other;
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Object obj = this.getObject();
        if (obj == (other = ((TripleBasedStruct)o).getObject())) {
            return true;
        }
        Collection<Triple> l1 = this.getSchemaTriplesForSubject(obj);
        Collection<Triple> l2 = this.getSchemaTriplesForSubject(other);
        if (l1.size() != l2.size()) {
            return false;
        }
        for (Triple t : l1) {
            if (l2.contains(t)) continue;
            return false;
        }
        return true;
    }

    private Collection<Triple> getSchemaTriplesForSubject(Object subj) {
        return this.store.getAll(new TripleImpl(subj, "rdfs:type", (Object)Variable.v));
    }
}

