/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.kie.builder.impl.MessageImpl;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class ResultsImpl
implements Results {
    private List<Message> messages = new ArrayList<Message>();
    private long idGenerator = 1L;

    public List<Message> getMessages() {
        return this.messages;
    }

    public boolean hasMessages(Message.Level ... levels) {
        return !this.filterMessages(levels).isEmpty();
    }

    public List<Message> getMessages(Message.Level ... levels) {
        return this.filterMessages(levels);
    }

    public void addMessage(CompilationProblem problem) {
        this.messages.add(new MessageImpl(this.idGenerator++, problem));
    }

    public MessageImpl addMessage(KnowledgeBuilderResult result) {
        MessageImpl message = new MessageImpl(this.idGenerator++, result);
        this.messages.add(message);
        return message;
    }

    public MessageImpl addMessage(Message.Level level, String path, String text) {
        MessageImpl message = new MessageImpl(this.idGenerator++, level, path, text);
        this.messages.add(message);
        return message;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public long getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(long idGenerator) {
        this.idGenerator = idGenerator;
    }

    public List<Message> filterMessages(Message.Level ... levels) {
        return MessageImpl.filterMessages(this.messages, levels);
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("Error Messages:\n");
        for (Message msg : this.filterMessages(Message.Level.ERROR)) {
            sBuilder.append(msg.toString());
            sBuilder.append("\n");
        }
        sBuilder.append("---\n");
        sBuilder.append("Warning Messages:\n");
        for (Message msg : this.filterMessages(Message.Level.WARNING)) {
            sBuilder.append(msg.toString());
            sBuilder.append("\n");
        }
        sBuilder.append("---\n");
        sBuilder.append("Info Messages:\n");
        for (Message msg : this.filterMessages(Message.Level.INFO)) {
            sBuilder.append(msg.toString());
            sBuilder.append("\n");
        }
        return sBuilder.toString();
    }
}

