% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_model.R
\name{df_to_model}
\alias{df_to_model}
\title{Create a \link{RelDataModel} object from column names of data frames}
\usage{
df_to_model(..., list = character(), pos = -1, envir = as.environment(pos))
}
\arguments{
\item{...}{the data frame objects, as names (unquoted) or character strings
(quoted)}

\item{list}{a character vector naming data frame objects}

\item{pos}{where to get the objects.
By default, uses the current environment.
See ‘details’ for other possibilities.}

\item{envir}{the environment to use. See ‘details’.}
}
\value{
A \link{RelDataModel} object.
}
\description{
Create a \link{RelDataModel} object from column names of data frames
}
\details{
The pos argument can specify the environment from which to get
the objects in any of several ways:
as an integer (the position in the search list);
as the character string name of an element in the search list;
or as an environment.
The envir argument is an alternative way to specify an environment,
but is primarily there for back compatibility.
}
\examples{
## Read data files ----
to_read <- list.files(
   system.file("examples/HPO-subset", package="ReDaMoR"),
   full.names=TRUE
)
hpo_tables <- list()
for(f in to_read){
   hpo_tables[[sub("[.]txt$", "", basename(f))]] <- readr::read_tsv(f)
}
## Build the model from a list of data frames ----
new_model <- df_to_model(
   list=names(hpo_tables), envir=as.environment(hpo_tables)
)
## Plot the model ----
new_model \%>\%
   auto_layout(lengthMultiplier=250) \%>\%
   plot()
}
