% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mintime.cor.test.R
\name{mintime.cor.test}
\alias{mintime.cor.test}
\title{Extracts a subset of uncorrelated  vectors}
\usage{
mintime.cor.test(XM_T, m = 1, alpha = 0.05)
}
\arguments{
\item{XM_T}{A numeric matrix  where the uncorrelated vectors are extracted from.}

\item{m}{Integer valu giving the starting column.}

\item{alpha}{Numeric value in \eqn{(0,1)}. It gives the  sgnificance level of the correlation test.}
}
\value{
A vector with the index of the uncorrelated columns in the matrix.
}
\description{
Given a  a set of \eqn{M} vectors,  this function extracts  a subset of  them which are uncorrelated.
}
\details{
This function is used in the data preparation  (or pre-processing) often
required to apply the record inference tools in this package.

 Given a  a set of \eqn{M} vectors, which are the columns of matrix \code{XM_T}, this function  extracts the  biggest subset of uncorrelated vectors (columns),
 using the following procedure: starting from  column \code{m},
the test \code{\link{cor.test}} is applied  to study the correlation between columns \code{m} and \code{m} + 1, \code{m} + 2, ... an so on  up to find  a
column \code{m} + k which  is not significantly correlated with column \code{m}. Then,  the process is repeated starting at column \code{m} + k.
}
\examples{
ZM_T <- DaySeries.fun(TX_Zaragoza$TX)
mintime.cor.test(ZM_T)
}
\seealso{
\code{\link{DaySeries.fun}}, \code{\link{double.fun}}
}
