% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_global.test.R
\name{L_global.test}
\alias{L_global.test}
\title{LM and LR tests with Monte Carlo global statistic}
\usage{
L_global.test(
  XM_T,
  test = c("LM", "LR"),
  statistic = c("G1", "G2"),
  trend = c("positive", "negative"),
  B = 1000,
  rdist = stats::runif,
  parallel = FALSE,
  numCores = 2,
  seed = NULL
)
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{test}{A character string indicating the type of test to perform. 
\code{"LM"} for \code{\link{L_lm.test}} or \code{"LR"} for 
\code{\link{L_lr.test}}.}

\item{statistic}{A character string indicating the type of generalization
to perform. \code{"G1"} or \code{"G2"} (see Details).}

\item{trend}{A character string indicating the type of alternative 
hypothesis, positive trend in location \code{"positive"} or
negative trend in location \code{"negative"}.}

\item{B}{An integer specifying the number of replicates used in the 
Monte Carlo approach.}

\item{rdist}{function that simulates continuous random variables, 
e.g., \code{\link{runif}} (fastest in \code{stats} package), 
\code{\link{rnorm}} or \code{\link{rexp}}.}

\item{parallel}{If \code{TRUE}, then the Monte Carlo algorithm is done in 
parallel. This can give a significant speedup on multicore machines.}

\item{numCores}{Allows the user to specify the amount of parallel processes 
to be used if \code{parallel = TRUE}. If \code{NULL}, then the number of 
logical cores is automatically detected and all available cores are used.}

\item{seed}{A vector of the same length as the value of \code{samples}. 
Allows the user to specify the seed of each Monte Carlo simulation. 
If \code{NULL}, then no seed is specified.}
}
\value{
A list of class \code{"htest"}  with the following elements:
  \item{statistic}{Value of the  statistic.}
  \item{parameter}{Number of replicates used in the Monte Carlo test.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
This function performs a more powerful generalization 
  of the Lagrange multiplier and likelihood ratio tests on records
  by means of the sum of the statistics of upper and lower records 
  and forward and backward series to study the hypothesis of the 
  classical record model.
}
\details{
Here, the Monte Carlo statistics with general alternative 
  \eqn{\mathcal{LM}} in \code{\link{L_lm.test}} or \eqn{\mathcal{LR}} in 
  \code{\link{L_lr.test}} if \code{test = 'LM'} or \code{test = 'LR'} 
  respectively, are joined for upper and lower records and forward and 
  backward series as
  \deqn{\mathcal{LM}^{G1} = \mathcal{LM} - \mathcal{LM}^{L} - \mathcal{LM}^{rev} + \mathcal{LM}^{L,rev}}
  or
  \deqn{\mathcal{LM}^{G2} = \mathcal{LM} + \mathcal{LM}^{L,rev}},
  where the superscripts \eqn{L} and \eqn{rev} means lower records and 
  reversed (or backwards) series, respectively. Equivalently for 
  \eqn{\mathcal{LR}}.
  
  The distribution of this generalized statistics is unknown, 
  but it can be estimated with a Monte Carlo approach.
}
\examples{
L_global.test(ZaragozaSeries, test = 'LM', B = 200)

L_global.test(ZaragozaSeries, test = 'LR', B = 200)

}
\seealso{
\code{\link{L_lm.test}}, \code{\link{L_lr.test}}
}
\author{
Jorge Castillo-Mateo
}
