% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N.test.R
\name{N.test}
\alias{N.test}
\title{Number of Records Test}
\usage{
N.test(
  X,
  weights = function(t) 1,
  record = c("upper", "lower"),
  distribution = c("normal", "t", "poisson-binomial"),
  alternative = c("greater", "less"),
  correct = TRUE,
  method = c("mixed", "dft", "butler"),
  simulate.p.value = FALSE,
  B = 1000
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series,
e.g., if \code{function(t) t-1} then \eqn{\omega_t = t-1}.}

\item{record}{A character string indicating the type of record to be 
calculated, \code{"upper"} or \code{"lower"}.}

\item{distribution}{A character string indicating the asymptotic 
distribution of the statistic, \code{"normal"} distribution, Student's
\code{"t"}-distribution or exact \code{"poisson-binomial"} distribution.}

\item{alternative}{A character string indicating the type of alternative 
hypothesis, \code{"greater"} number of records or \code{"less"} number of
records.}

\item{correct}{Logical. Indicates, whether a continuity correction 
should be done; defaults to \code{TRUE}. No correction is done if
\code{simulate.p.value = TRUE} or \code{distribution = "poisson-binomial"}.}

\item{method}{(If \code{distribution = "poisson-binomial"}.) A character 
string that indicates the method by which the cdf
of the Poisson binomial distribution is calculated and therefore the 
p-value. \code{"mixed"} is the preferred (and default) method, it is a 
more efficient combination of the later algorithms. \code{"dft"} uses the 
discrete Fourier transform which algorithm is given in Hong (2013). 
\code{"butler"} use the algorithm given by Butler and Stephens (2016).}

\item{simulate.p.value}{Logical. Indicates whether to compute p-values by
Monte Carlo simulation. No simulation is done if 
\code{distribution = "poisson-binomial"}.}

\item{B}{If \code{simulate.p.value = TRUE}, an integer specifying the 
number of replicates used in the Monte Carlo estimation.}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the test statistic.}
  \item{parameter}{(If \code{distribution = "t"}.) Degrees of freedom of
    the \eqn{t} statistic (equal to \eqn{M-1}).}
  \item{p.value}{P-value.}
  \item{alternative}{The alternative hypothesis.}
  \item{estimate}{(If \code{distribution = "normal"}) A vector with the
    value of \eqn{N_{..}^\omega}, \eqn{\mu} and \eqn{\sigma^2}.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
Performs tests based on the (weighted) number of records, 
  \eqn{N^\omega}. The hypothesis of the classical record model (i.e., of IID
  continuous RVs) is tested against the alternative hypothesis.
}
\details{
The null hypothesis is that the data come from a population with 
  independent and identically distributed continuous realisations. The 
  one-sided alternative hypothesis is that the (weighted) number of records
  is greater (or less) than under the null hypothesis. The 
  (weighted)-number-of-records statistic is calculated according to:
  \deqn{N_{..}^\omega = \sum_{m=1}^M \sum_{t=1}^T \omega_t I_{tm},} 
  where \eqn{\omega_t} are weights given to the different records
  according to their position in the series and \eqn{I_{tm}} are the record
  indicators (see \code{\link{I.record}}).
  
  The statistic \eqn{N_{..}^\omega} is exact Poisson binomial distributed
  when the \eqn{\omega_t}'s only take values in \eqn{\{0,1\}}. In any case,
  it is also approximately normally distributed, with
  \deqn{Z = \frac{N_{..}^\omega - \mu}{\sigma},}
  where its mean and variance are
  \deqn{\mu = M \sum_{t=1}^T \omega_t \frac{1}{t},} 
  \deqn{\sigma^2 = M \sum_{t=2}^T \omega_t^2 \frac{1}{t} \left(1-\frac{1}{t}\right).} 
  
  If \code{correct = TRUE}, then a continuity correction will be employed:
  \deqn{Z = \frac{N_{..}^\omega \pm 0.5 - \mu}{\sigma},}
  with ``\eqn{-}'' if the alternative is greater and ``\eqn{+}'' if the 
  alternative is less.
  
  When \eqn{M>1}, the expression of the variance under the null hypothesis
  can be substituted by the sample variance in the \eqn{M} series, 
  \eqn{\hat{\sigma}^2}. In this case, the statistic \eqn{N_{S,..}^\omega}
  is asymptotically \eqn{t} distributed, which is a more robust alternative
  against serial correlation.
  
  If \code{simulate.p.value = TRUE}, the p-value is estimated by Monte Carlo
  simulations.
  
  The size of the tests is adequate for any values of \eqn{T} and \eqn{M}.
  Some comments and a power study are given by Cebrián, Castillo-Mateo and
  Asín (2021).
}
\examples{
# Forward Upper records
N.test(ZaragozaSeries)
# Forward Lower records
N.test(ZaragozaSeries, record = "lower", alternative = "less")
# Forward Upper records
N.test(series_rev(ZaragozaSeries), alternative = "less")
# Forward Upper records
N.test(series_rev(ZaragozaSeries), record = "lower")

# Exact test
N.test(ZaragozaSeries, distribution = "poisson-binom")
# Exact test for records in the last decade
N.test(ZaragozaSeries, weights = function(t) ifelse(t < 61, 0, 1), distribution = "poisson-binom")
# Linear weights for a more powerful test (without continuity correction)
N.test(ZaragozaSeries, weights = function(t) t-1, correct = FALSE)

}
\references{
Butler K, Stephens MA (2017).
“The Distribution of a Sum of Independent Binomial Random Variables.”
\emph{Methodology and Computing in Applied Probability}, \strong{19}(2), 557-571.
\doi{10.1007/s11009-016-9533-4}

Cebrián A, Castillo-Mateo J and Asín J (2021).
“Record Tests to Detect Non Stationarity in the Tails with an Application to Climate Change.”
Available at Research Square \doi{10.21203/rs.3.rs-214787/v1}

Hong Y (2013). 
“On Computing the Distribution Function for the Poisson Binomial Distribution.”
\emph{Computational Statistics & Data Analysis}, \strong{59}(1), 41-51.
\doi{10.1016/j.csda.2012.10.006}
}
\seealso{
\code{\link{N.record}}, \code{\link{N.plot}}, 
  \code{\link{foster.test}}, \code{\link{foster.plot}},
  \code{\link{brown.method}}
}
\author{
Jorge Castillo-Mateo
}
