% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BibEntryReplaceOp.R
\name{[<-.BibEntry}
\alias{[<-.BibEntry}
\title{Update Different Fields of Multiple Entries of a BibEntry Object}
\usage{
\method{[}{BibEntry}(x, i, j, ...) <- value
}
\arguments{
\item{x}{- a BibEntry object.}

\item{i}{- see \code{\link{[.BibEntry}}}

\item{j}{- see \code{\link{[.BibEntry}}}

\item{...}{- see \code{\link{[.BibEntry}}}

\item{value}{- values to be assigned to \code{x}.  To update one entry only,
should be a named character vector with names corresponding to fields.  To update
multiple entries, should be a list of named character vectors.  Can also be an object of
class BibEntry.}
}
\value{
an object of class BibEntry.
}
\description{
Assign new values for specified fields in a BibEntry object using a named
character vector or list of named character vectors.
}
\details{
Date and name list fields should be in the format expected
by Biblatex (see \code{\link{BibEntry}}).

To clear a field \sQuote{field_name} from an entry use \code{field_name = ""}.
}
\examples{
file.name <- system.file("Bib", "RJC.bib", package="RefManageR")
bib <- ReadBib(file.name)
print(bib[seq_len(3L)], .opts = list(sorting = "none", bib.style = "alphabetic"))
## add month to Serban et al., add URL and urldate to Jennings et al., and
##   add DOI and correct journal to Garcia et al.
bib[seq_len(3L)] <- list(c(date="2013-12"),
                        c(url="http://bsb.eurasipjournals.com/content/2013/1/13",
                          urldate = "2014-02-02"),
                        c(doi="10.1093/bioinformatics/btt608",
                          journal = "Bioinformatics"))
print(bib[seq_len(3L)], .opts = list(sorting = "none", bib.style = "alphabetic"))
bib2 <- bib[seq_len(3L)]
bib2[2:3] <- bib[5:6]
bib2
bib2[3] <- c(journal='', eprinttype = "arxiv", eprint = "1308.5427",
  eprintclass = "math.ST", pubstate = "submitted", bibtype = "misc")
bib2
}
\seealso{
Other operators: \code{\link{$.BibEntry}};
  \code{\link{$<-.BibEntry}}; \code{\link{+.BibEntry}},
  \code{\link{+.BibEntry}}, \code{\link{merge.BibEntry}};
  \code{\link{SearchBib}}, \code{\link{[.BibEntry}},
  \code{\link{[.BibEntry}}; \code{\link{[[.BibEntry}};
  \code{\link{[[<-.BibEntry}}; \code{\link{c.BibEntry}}
}
\keyword{manip}
\keyword{methods}

