% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadPDFs.R
\name{ReadPDFs}
\alias{ReadPDFs}
\title{Create bibliographic information from PDF Metadata.}
\usage{
ReadPDFs(path, .enc = "UTF-8", recursive = TRUE, use.crossref = TRUE,
  use.metadata = TRUE, progress = FALSE)
}
\arguments{
\item{path}{character; path to directory containing pdfs or filename of
one pdf. \code{normalizePath} is used on the specified path}

\item{.enc}{character; text encoding to use for reading pdf and creating
BibEntry object. Available encodings for Poppler can be found using
\code{system("pdfinfo -listenc")}.  The encoding must also be listed
in \code{iconvlist()}.}

\item{recursive}{logical; same as \code{\link{list.files}}.  Should pdfs
in subdirectories of path be used?}

\item{use.crossref}{logical; should an attempt be made to download bibliographic
information from CrossRef if
any Document Object Identifiers (DOIs) are found?}

\item{use.metadata}{logical; should the PDF metadata also be used to help
create entries?}

\item{progress}{logical; should progress bar be generated when fetching from
CrossRef?}
}
\value{
An object of class BibEntry.
}
\description{
This function creates bibliographic information by reading the Metadata and
text of PDFs stored in a user specified directory using Poppler
(\url{https://poppler.freedesktop.org/}).  IF requested, the function
first searches for DOIs and downloads \code{BibTeX} entries from
\code{\link{ReadCrossRef}} if DOIs are found.  If this is not requested or
a DOI is not found for an entry, an attempt is made to build a BibTeX
entry from the metadata and text.
}
\details{
This function requires that the \code{pdfinfo} utility from Poppler PDF
\url{https://poppler.freedesktop.org/} be installed.

This function will create only \code{Article} or \code{Misc} \code{BibTeX} entries.

The absolute path to each file will be stored in the bib entry in a field
called \sQuote{file}, which is recognized by \code{BibLaTeX} (though not printed by
any standard style) and can be used by the
\code{\link{open.BibEntry}} function to open the PDF in the default viewer.

If the keywords metadata field is available, it will be added to the bib entry
in a field \sQuote{keywords}, which is recognized by \code{BibLaTeX}.
}
\examples{
\dontrun{
path <- system.file("doc", package = "RefManageR")
ReadPDFs(path)
}
}
\references{
\url{https://poppler.freedesktop.org/}
}
\seealso{
\code{\link{ReadCrossRef}}, \code{\link{BibEntry}},
\code{\link{open.BibEntry}}
}
\keyword{utilities}
