% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_radial_test.R
\name{compute_radial_test}
\alias{compute_radial_test}
\title{Function to compute the DGM bounds on the noncommon regressor Xnc,  adapted to the point identification test.}
\usage{
compute_radial_test(
  sample1 = NULL,
  Xc_x,
  Xnc,
  Xc_y,
  Y,
  values,
  dimXc,
  dimXnc,
  nb_pts,
  sam0,
  eps_default0,
  grid = NULL,
  lim = 10,
  weights_x = NULL,
  weights_y = NULL,
  constraint = NULL,
  c_sign = NULL,
  nc_sign = NULL,
  refs0 = NULL,
  type = "both",
  meth = "adapt",
  version = "first",
  R2bound = NULL,
  values_sel = NULL,
  ties = FALSE
)
}
\arguments{
\item{sample1}{if NULL compute the point estimate, if a natural number then evaluate a bootstrap or subsampling replication.}

\item{Xc_x}{the common regressor on the dataset  (Xnc,Xc). Default is NULL.}

\item{Xnc}{the noncommon regressor on the dataset  (Xnc,Xc). No default.}

\item{Xc_y}{the common regressor on the dataset  (Y,Xc). Default is NULL.}

\item{Y}{the outcome variable. No default.}

\item{values}{the different unique points of support of the common regressor Xc.}

\item{dimXc}{the dimension of the common regressors Xc.}

\item{dimXnc}{the dimension of the noncommon regressors Xnc.}

\item{nb_pts}{the constant C in DGM for the epsilon_0, the lower bound on the grid for epsilon, taken equal to nb_pts*ln(n)/n. Default is 1 without regressors Xc, 3 with Xc.}

\item{sam0}{the directions q to compute the variance bounds on the radial function.}

\item{eps_default0}{the matrix containing the directions q and the selected epsilon(q).}

\item{grid}{the number of points for the grid search on epsilon. Default is 30. If NULL, then epsilon is taken fixed equal to kp.}

\item{lim}{the limit number of observations under which we do no compute the conditional variance.}

\item{weights_x}{the sampling weights for the dataset (Xnc,Xc).}

\item{weights_y}{the sampling weights for the dataset (Y,Xc).}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.}

\item{c_sign}{sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no contraints.}

\item{nc_sign}{sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no contraints.}

\item{refs0}{indicating the positions in the vector values corresponding to the components of betac.}

\item{type}{equal to "both", "up", or "low".}

\item{meth}{the method for the choice of epsilon, either "adapt", i.e. adapted to the direction or "min" the minimum over the directions. Default is "adapt".}

\item{version}{version of the computation of the ratio, "first" indicates no weights, no ties, same sizes of the two datasets; "second" otherwise. Default is "second".}

\item{R2bound}{the lower bound on the R2 of the long regression if any. Default is NULL.}

\item{values_sel}{the selected values of Xc for the conditioning. Default is NULL.}

\item{ties}{Boolean indicating if there are ties in the dataset. Default is FALSE.}
}
\value{
a list contaning:

 - upper: the upper bound in the specified directions, possibly with sign constraints

 - lower: the lower bound in the specified directions, possibly with sign constraints

 - unconstr: the bounds without sign constraints in the specified directions

 - Ykmean: the means of Y|Xc for the considered sample

 - Xkmean: the means of Xnc|Xc for the considered sample

 - DYk: the difference of means of Y|Xc =k -  Y|Xc =0 for the considered sample

 - DXk: the difference of means of Xnc|Xc =k -  Xnc|Xc =0 for the considered sample

 - tests: the pvalues of the tests H0 : DXk =0

 - ratio_ref: the ratio R in the radial function computed for the initial sample
}
\description{
Function to compute the DGM bounds on the noncommon regressor Xnc,  adapted to the point identification test.
}
