% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateC.R
\name{CalculateCdirect}
\alias{CalculateCdirect}
\alias{CalculateC}
\title{Calculation of C by solving equation 10 in the paper}
\usage{
CalculateCdirect(a, b, epsAlpha = 1e-07, AlphaHandler = warning,
  alpha = NULL)

CalculateC(a, b, ..., viaQR = NULL, returnAlpha = FALSE)
}
\arguments{
\item{a}{matrix E in paper}

\item{b}{matrix Eg in paper}

\item{epsAlpha}{Precision constant for alpha calculation}

\item{AlphaHandler}{Function (warning or stop) to be used when alpha<1}

\item{alpha}{Possible with alpha as input instead of computing}

\item{...}{Arguments to CalculateCdirect}

\item{viaQR}{When TRUE QR is involved. This may be needed to handle colinear data. When NULL viaQR is set to TRUE if ordinary computations fail.}

\item{returnAlpha}{When TRUE alpha (1 or value below 1) is returned instead of C. Attribute viaQR is included.}
}
\value{
Calculated C with attributes alpha and viaQR (when CalculateC)
}
\description{
The limit calculated by \code{\link{FindAlpha}} is used when alpha =1 cannot be chosen (warning produced). 
In output, alpha is attribute.
}
\details{
When epsAlpha=NULL calculations are performed directly (alpha=1) and alpha is not attribute.
}
\examples{
x <- 1:10
y <- matrix(rnorm(30) + 1:30, 10, 3)
a <- residuals(lm(y ~ x))
b <- residuals(lm(2 * y + matrix(rnorm(30), 10, 3) ~ x))

a1 <- a
b1 <- b
a1[, 3] <- a[, 1] + a[, 2]
b1[, 3] <- b[, 1] + b[, 2]

alpha <- FindAlpha(a, b)
FindAlphaSimple(a, b)  # Same result as above
CalculateC(a, b)
CalculateCdirect(a, b)  # Same result as above without viaQR attribute 
CalculateCdirect(a, b, alpha = alpha/(1 + 1e-07))  # Same result as above since epsAlpha = 1e-07
CalculateCdirect(a, b, alpha = alpha/2)  # OK
# CalculateCdirect(a,b, alpha = 2*alpha) # Not OK

FindAlpha(a, b1)
# FindAlphaSimple(a,b1) # Not working since b1 is collinear
CalculateC(a, b1, returnAlpha = TRUE)  # Almost same alpha as above (epsAlpha cause difference)

FindAlpha(b, a)
CalculateC(b, a, returnAlpha = TRUE)  # 1 returned (not same as above)
CalculateC(b, a)

FindAlpha(b1, a)   # alpha smaller than epsAlpha is set to 0 in CalculateC
CalculateC(b1, a)  # When alpha = 0 C is calculated by GenQR insetad of chol
}
