% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenQR.R
\encoding{UTF8}
\name{GenQR}
\alias{GenQR}
\title{Generalized QR decomposition}
\usage{
GenQR(x, doSVD = FALSE, findR = TRUE, makeunique = findR,
  tol = 1e-07)
}
\arguments{
\item{x}{Matrix to be decomposed}

\item{doSVD}{When TRUE SVD instead of QR}

\item{findR}{When FALSE only Q returned}

\item{makeunique}{When TRUE force uniqueness by positive diagonal elements (QR) or by column sums (SVD)}

\item{tol}{As input to qr or, in the case of svd(), similar as input to MASS::ginv().}
}
\value{
List with Q and R or just Q
}
\description{
Matrix X decomposed as Q and R (X=QR) where columns of Q are orthonormal.
Ordinary QR or SVD may be used.
}
\details{
To handle dependency a usual decomposition of X is PX=QR where P is a permutation matrix. 
This function returns RP^T as R. When SVD, Q=U and R=SV^T.
}
\examples{
   GenQR(matrix(rnorm(15),5,3))
   GenQR(matrix(rnorm(15),5,3)[,c(1,2,1,3)])
   GenQR(matrix(rnorm(15),5,3)[,c(1,2,1,3)],TRUE)
}
