% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAF.R
\name{VAF}
\alias{VAF}
\title{Proportion of variance accounted for (VAF) for each block and each principal component.}
\usage{
VAF(DATA, Jk, R)
}
\arguments{
\item{DATA}{A matrix, which contains the concatenated data with the same subjects from multiple blocks.
Note that each row represents a subject.}

\item{Jk}{A vector containing number of variables in the concatinated data matrix.}

\item{R}{Number of components (R>=2).}
}
\value{
\item{block}{Proportion of VAF for each block.}
\item{component}{Proportion of VAF for each component of each block.}
}
\description{
Proportion of variance accounted for (VAF) is calculated for each block and each column.
}
\examples{
\dontrun{
DATA1 <- matrix(rnorm(50), nrow=5)
DATA2 <- matrix(rnorm(100), nrow=5) 
DATA <- cbind(DATA1, DATA2)
Jk <- c(10, 20) 
R <- 5
VAF(DATA, Jk, R)
}
}
\references{
Schouteden, M., Van Deun, K., Wilderjans, T. F., & Van Mechelen, I. (2014). 
Performing DISCO-SCA to search for distinctive and common information in linked data. 
Behavior research methods, 46(2), 576-587.

Schouteden, M., Van Deun, K., Pattyn, S., & Van Mechelen, I. (2013). 
SCA with rotation to distinguish common and distinctive information in linked data. 
Behavior research methods, 45(3), 822-833.
}
