\name{xenv}
\alias{xenv}
\title{Fit the envelope model in the predictor space}
\description{
 Fit the envelope model in the predictor space with dimension u under linear regression. 
}
\usage{
xenv(X, Y, u, asy = TRUE, init = NULL)
}
\arguments{
  \item{X}{Predictors. An n by p matrix, p is the number of predictors and n is number of observations.  The predictors must be continuous variables.}
  \item{Y}{Responses. An n by r matrix, r is the number of responses. The response can be univariate or multivariate and must be continuous variable.}
  \item{u}{Dimension of the envelope. An integer between 0 and p.}
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{init}{The user-specified value of Gamma for the envelope subspace in the predictor space. An p by u matrix. The default is the one generated by function envMU.}
}
\details{
 This function fits the envelope model in the predictor space, \deqn{
 Y = \mu + \eta'\Omega^{-1}\Gamma' X +\varepsilon, \Sigma_{X}=\Gamma\Omega\Gamma'+\Gamma_{0}\Omega_{0}\Gamma'_{0}
}
using the maximum likelihood estimation.  When the dimension of the envelope is between 1 and p-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is p, then the envelope model degenerates to the standard multivariate linear regression.  When the dimension is 0, it means that X and Y are uncorrelated, and the fitting is different.
}
\value{The output is a list that contains the following components:
\item{beta}{The envelope estimator of the regression coefficients.} 
\item{SigmaX}{The envelope estimator of the covariance matrix of X.}
\item{Gamma}{An orthonormal basis of the envelope subspace.}
\item{Gamma0}{An orthonormal basis of the complement of the envelope subspace.}
\item{eta}{The estimated eta.  According to the envelope parameterization, beta = Gamma * Omega^{-1} * eta.}
\item{Omega}{The coordinates of SigmaX with respect to Gamma.}
\item{Omega0}{The coordinates of SigmaX with respect to Gamma0.}
\item{mu}{The estimated intercept.}
\item{SigmaYcX}{The estimated conditional covariance matrix of Y given X.}
\item{loglik}{The maximized log likelihood function.}
\item{covMatrix}{The asymptotic covariance of vec(beta). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.}
\item{asySE}{The asymptotic standard error for elements in beta under the envelope model.  The standard errors returned are asymptotic, for actual standard errors, multiply by 1 / sqrt(n).}
\item{ratio}{The asymptotic standard error ratio of the standard multivariate linear regression estimator over the envelope estimator, for each element in beta.}
\item{n}{The number of observations in the data.}
}
\seealso{
\code{\link[pls]{simpls.fit}} for partial least squares (PLS).	
}
\references{
Cook, R. D., Helland, I. S. and Su, Z. (2013). Envelopes and Partial Least Squares Re-
gression. Journal of the Royal Statistical Society: Series B 75, 851 - 877.

Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
## Fit the envelope in the predictor space	
data(wheatprotein)
X <- wheatprotein[, 1:6]
Y <- wheatprotein[, 7]
u <- u.xenv(X, Y)
u

m <- xenv(X, Y, 4)
m
m$beta


\dontrun{m1 <- pls::simpls.fit(X, Y, 4)}
\dontrun{m1$coefficients}
}

