/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.html4r.elements;

import java.util.Iterator;
import java.util.LinkedHashMap;

import org.lysis.reporters.tools.HTML4R;

public class MenuBar implements Cloneable, HTML4R {
	private LinkedHashMap<String, String> titles;
	private String brand;
	private String activeTitle;
	
	public MenuBar(String headStr){
		titles = new LinkedHashMap<String, String>();
		brand = org.apache.commons.lang.StringEscapeUtils.escapeHtml(headStr);
	}
	
	public void addTitle(String title, String filename){
		titles.put(title, filename);
	}
	
	public void setActiveTitle(String title){
		activeTitle = title;
	}
	
	public Object clone() {
		Object o = null;
		try {
			// On rcupre l'instance  renvoyer par l'appel de la 
			// mthode super.clone()
			o = super.clone();
		} catch(CloneNotSupportedException cnse) {
			// Ne devrait jamais arriver car nous implmentons 
			// l'interface Cloneable
			cnse.printStackTrace(System.err);
		}
		// on renvoie le clone
		return o;
	}


	public String getHTML() {
		String ul = "";
		for (Iterator<String> it1 = titles.keySet().iterator(); it1.hasNext();) {
			String title = it1.next();
			String link = titles.get(title);
			if( activeTitle.equals(title) )
				ul += "<li class=\"active\"><a href=\"" + link + "\">" + org.apache.commons.lang.StringEscapeUtils.escapeHtml(title) + "</a></li>";
			else ul += "<li><a href=\"" + link + "\">" + org.apache.commons.lang.StringEscapeUtils.escapeHtml(title) + "</a></li>";
		}
		ul += "";

		String temp = "<header class=\"navbar navbar-static-top bs-docs-nav navbar-default\" id=\"top\" role=\"banner\">"
				  + "<div class=\"container\">"
				    + "<div class=\"navbar-header\">"
				      + "<button class=\"navbar-toggle\" type=\"button\" data-toggle=\"collapse\" data-target=\".bs-navbar-collapse\">"
				        + "<span class=\"sr-only\">Toggle navigation</span>"
				        + "<span class=\"icon-bar\"></span>"
				        + "<span class=\"icon-bar\"></span>"
				        + "<span class=\"icon-bar\"></span>"
				      + "</button>"
				      + "<a href=\"#\" class=\"navbar-brand\">" + brand + "</a>"
				    + "</div>"
				    + "<nav class=\"collapse navbar-collapse bs-navbar-collapse\" role=\"navigation\">"
				      + "<ul class=\"nav navbar-nav\">"
				      + ul
				      + "</ul>"
				      + "</nav>"
				    + "</div>"
				  + "</header>";
		return temp;

	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}


}
