/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.relationships.Relationship;
import org.lysis.reporters.lists.NumberingDefinition;
import org.lysis.reporters.pptx4r.elements.template.LayoutDescription;
import org.lysis.reporters.pptx4r.elements.template.MasterLayoutProperties;
import org.lysis.reporters.pptx4r.tools.DocExplorer;
import org.pptx4j.pml.Presentation;

public class pptx4R {
    public static int NO_ERROR = 0;
    public static int READDOC_ERROR = 1;
    public static int LOADDOC_ERROR = 2;
    public static int LAYOUT_ERROR = 3;
    public static int SAVE_ERROR = 4;
    public static int PARTNAME_ERROR = 5;
    public static int SLIDECREATION_ERROR = 6;
    public static int UNDEFINED_ERROR = -1;
    private PresentationMLPackage baseDocument;
    private int slideIndex = 0;
    private MasterLayoutProperties masterLayoutProperties;
    private HashMap<String, LayoutDescription> layoutList;
    private int width;
    private int height;
    private NumberingDefinition numberingDefinition;

    private int getNewUIDSlide() {
        ++this.slideIndex;
        return this.slideIndex;
    }

    public int[] readSlideDimensions() {
        PartName presentationPartname = null;
        int[] dims = new int[2];
        dims[1] = -1;
        dims[0] = -1;
        try {
            presentationPartname = new PartName("/ppt/presentation.xml");
            MainPresentationPart mainPresentationPart = (MainPresentationPart)this.baseDocument.getParts().getParts().get(presentationPartname);
            dims[0] = ((Presentation)mainPresentationPart.getJaxbElement()).getSldSz().getCx();
            dims[1] = ((Presentation)mainPresentationPart.getJaxbElement()).getSldSz().getCy();
        }
        catch (InvalidFormatException e) {
            System.err.println("unable to read presentation.xml.");
        }
        return dims;
    }

    public void setNumberingDefinition(NumberingDefinition nd) {
        this.numberingDefinition = nd;
    }

    public NumberingDefinition getNumberingDefinition() {
        return this.numberingDefinition;
    }

    public int setBaseDocument(String baseDocFileName) {
        File baseDocFile = null;
        try {
            baseDocFile = new File(baseDocFileName);
        }
        catch (Exception e) {
            return READDOC_ERROR;
        }
        try {
            this.baseDocument = PresentationMLPackage.load((File)baseDocFile);
        }
        catch (Docx4JException e) {
            return LOADDOC_ERROR;
        }
        this.slideIndex = DocExplorer.countExistingSlides(this.baseDocument);
        try {
            this.layoutList = new HashMap();
            this.layoutList = DocExplorer.browseLayouts(this.baseDocument);
            this.masterLayoutProperties = new MasterLayoutProperties();
            this.masterLayoutProperties.feed(this.baseDocument);
        }
        catch (InvalidFormatException e) {
            System.out.println("LAYOUT_ERROR");
            return LAYOUT_ERROR;
        }
        return NO_ERROR;
    }

    public int writePptxToStream(String target) throws Exception {
        File f = new File(target);
        try {
            this.baseDocument.save(f);
            return NO_ERROR;
        }
        catch (Docx4JException e) {
            return SAVE_ERROR;
        }
    }

    public String[] getStyleNames() {
        String[] stylenames = new String[this.layoutList.size()];
        int i = 0;
        Iterator<String> it1 = this.layoutList.keySet().iterator();
        while (it1.hasNext()) {
            stylenames[i] = it1.next();
            ++i;
        }
        return stylenames;
    }

    public int getSlideNumber() {
        return this.slideIndex;
    }

    public SlidePart getNewSlide(String layoutName) throws Exception {
        if (!this.layoutList.containsKey(layoutName)) {
            throw new Exception("No layout named " + layoutName);
        }
        PartName presentationPartname = null;
        PartName LayoutPartname = null;
        PartName slidePartname = null;
        SlidePart slidePart = null;
        int UIDSlide = this.getNewUIDSlide();
        try {
            presentationPartname = new PartName("/ppt/presentation.xml");
            LayoutPartname = new PartName(this.layoutList.get(layoutName).getXMLFilename());
            slidePartname = new PartName("/ppt/slides/slide" + UIDSlide + ".xml");
        }
        catch (InvalidFormatException e) {
            System.err.println("unable to create one of the partnames.");
        }
        MainPresentationPart mainPresentationPart = (MainPresentationPart)this.baseDocument.getParts().getParts().get(presentationPartname);
        SlideLayoutPart layoutPart = (SlideLayoutPart)this.baseDocument.getParts().getParts().get(LayoutPartname);
        this.width = ((Presentation)mainPresentationPart.getJaxbElement()).getSldSz().getCx();
        this.height = ((Presentation)mainPresentationPart.getJaxbElement()).getSldSz().getCy();
        try {
            if (this.slideIndex < 2) {
                ((Presentation)mainPresentationPart.getJaxbElement()).setSldIdLst(new Presentation.SldIdLst());
            }
            slidePart = new SlidePart(slidePartname);
            slidePart.setContents((Object)SlidePart.createSld());
            mainPresentationPart.addSlide(slidePart);
            slidePart.addTargetPart((Part)layoutPart);
        }
        catch (InvalidFormatException e) {
            System.err.println("unable to create a new slide.");
        }
        catch (JAXBException e) {
            System.err.println("unable to create a new slide.");
        }
        return slidePart;
    }

    public SlidePart getAndReInitExistingSlide(String layoutName, int UIDSlide) throws Exception {
        PartName presentationPartname = null;
        PartName LayoutPartname = null;
        PartName slidePartname = null;
        MainPresentationPart presentation = this.baseDocument.getMainPresentationPart();
        try {
            presentationPartname = new PartName("/ppt/presentation.xml");
            LayoutPartname = new PartName(this.layoutList.get(layoutName).getXMLFilename());
            slidePartname = new PartName("/ppt/slides/slide" + UIDSlide + ".xml");
        }
        catch (InvalidFormatException e) {
            System.err.println("unable to create one of the partnames.");
        }
        MainPresentationPart mainPresentationPart = (MainPresentationPart)this.baseDocument.getParts().getParts().get(presentationPartname);
        SlideLayoutPart layoutPart = (SlideLayoutPart)this.baseDocument.getParts().getParts().get(LayoutPartname);
        this.width = ((Presentation)mainPresentationPart.getJaxbElement()).getSldSz().getCx();
        this.height = ((Presentation)mainPresentationPart.getJaxbElement()).getSldSz().getCy();
        Part part = this.baseDocument.getParts().get(slidePartname);
        Relationship rel = (Relationship)part.getSourceRelationships().get(0);
        presentation.removeSlide(rel);
        --this.slideIndex;
        SlidePart slidePart = null;
        try {
            if (this.slideIndex < 2) {
                ((Presentation)mainPresentationPart.getJaxbElement()).setSldIdLst(new Presentation.SldIdLst());
            }
            slidePart = new SlidePart(slidePartname);
            slidePart.setContents((Object)SlidePart.createSld());
            mainPresentationPart.addSlide(UIDSlide - 1, slidePart);
            slidePart.addTargetPart((Part)layoutPart);
        }
        catch (InvalidFormatException e) {
            System.err.println("unable to create a new slide.");
        }
        catch (JAXBException e) {
            System.err.println("unable to create a new slide.");
        }
        return slidePart;
    }

    public int getDocWidth() {
        return this.width;
    }

    public int getDocHeight() {
        return this.height;
    }

    public LayoutDescription getLayoutProperties(String slideName) {
        LayoutDescription ld = this.layoutList.get(slideName);
        ld.fixMissingXfrm(this.masterLayoutProperties);
        return ld;
    }

    public MasterLayoutProperties getMasterLayoutProperties() {
        return this.masterLayoutProperties;
    }

    protected PresentationMLPackage getBaseDocument() {
        return this.baseDocument;
    }
}

