package org.lysis.reporters.html4r.elements.menu;

import java.util.LinkedList;

import org.lysis.reporters.tools.HTML4R;

public class Dropdown implements HTML4R{

	private LinkedList<HTML4R> items;
	private String label;
	private boolean active;
	
	public Dropdown(String lab){
		items = new LinkedList<HTML4R>();
		label = lab;
		active = false;
	}
	public void setActive(){
		active = true;
	}
	public void addSeparator( ){
		items.add(new Separator());
	}
	public void add( String label, String link, boolean active ){
		MenuLink l = new MenuLink(label, link);
		if( active ) l.setActive();
		items.add(l);
	}
	public void add( Dropdown d){
		items.add(d);
	}
	
	
	@Override
	public String getHTML() {
		String out = "<li class=\"dropdown";
		if( active ) out += " active";
		out += "\"><a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">";
		out += label;
		out += "<b class=\"caret\"></b></a>";
		if( items.size() > 0 ){
			out += "<ul class=\"dropdown-menu\">";
			for(int i = 0 ; i < items.size() ; i++ ){
				out += items.get(i).getHTML();
			}
			out += "</ul>";
		}
		out += "</li>";
		return out;
	}
	
	@Override
	public String getCSS() {
		return "";
	}
	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	
}
