\name{addRScript.docx}
\alias{addRScript.docx}
\title{Add R script into a docx object}
\usage{
\method{addRScript}{docx}(doc, rscript, file, text, bookmark,
  par.properties = parProperties(), ...)
}
\arguments{
  \item{doc}{Object of class \code{\link{docx}} where
  expressions have to be added}

  \item{file}{R script file. Not used if text or rscript is
  provided.}

  \item{text}{character vector. The text to parse. Not used
  if file or rscript is provided.}

  \item{rscript}{an object of class \code{RScript}. Not
  used if file or text is provided.}

  \item{par.properties}{paragraph formatting properties of
  the paragraphs that contain rscript. An object of class
  \code{\link{parProperties}}}

  \item{bookmark}{a character value ; id of the Word
  bookmark to replace by the script. optional. See
  \code{\link{bookmark}}.}

  \item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{docx}}.
}
\description{
Add R script into a \code{\link{docx}} object.
}
\details{
You have to one of the following argument: file or text or
rscript.
}
\examples{
\donttest{
doc.filename = "addRScript_example.docx"
# Create a new document
doc = docx( title = "title" )

an_rscript = RScript( text = "ls()
x = rnorm(10)" )
doc = addRScript(doc, an_rscript )

doc = addPageBreak( doc )

doc = addRScript(doc, text = "ls()" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{docx}}, \code{\link{addRScript}},
\code{\link{bookmark}}
}

