% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addFooter.pptx.R
\name{addFooter.pptx}
\alias{addFooter.pptx}
\title{Insert a footer shape into a document pptx object}
\usage{
\method{addFooter}{pptx}(doc, value, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object}

\item{value}{character value to add into the footer shape of the current slide.}

\item{...}{further arguments, not used.}
}
\value{
a document object
}
\description{
Insert a footer shape into the current slide of a \code{pptx} object.
}
\examples{
\dontrun{
doc.filename = "addFooter_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )
# add a slide with layout "Title Slide"
doc = addSlide( doc, slide.layout = "Title Slide" )
#set the main title
doc = addTitle( doc, "Presentation title" ) 
#set the sub-title
doc = addSubtitle( doc , "This document is generated with ReporteRs.")

## add a page number on the current slide
doc = addFooter( doc, "Hi!" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{addDate.pptx}}
, \code{\link{addPageNumber.pptx}}
}

