/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docx4r.tools;

import java.util.List;
import java.util.Vector;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.P;
import org.docx4j.wml.Text;
import org.lysis.reporters.docx4r.tools.BookmarkObject;

public class DocExplorer {
    private static Vector<String> traversePartForBookmarkNames(Object parent) {
        Vector<String> out = new Vector<String>();
        List children = TraversalUtil.getChildrenImpl((Object)parent);
        if (children != null) {
            for (Object o : children) {
                if ((o = XmlUtils.unwrap(o)) instanceof CTBookmark) {
                    CTBookmark bm = (CTBookmark)o;
                    out.add(bm.getName());
                }
                out.addAll(DocExplorer.traversePartForBookmarkNames(o));
            }
        }
        return out;
    }

    public static String[] getBookmarkNames(WordprocessingMLPackage wmlp, boolean body, boolean header, boolean footer) throws Exception {
        Vector<String> temp = new Vector<String>();
        if (body) {
            temp.addAll(DocExplorer.traversePartForBookmarkNames(wmlp.getMainDocumentPart()));
        }
        if (header || footer) {
            List sectionWrappers = wmlp.getDocumentModel().getSections();
            for (SectionWrapper sw : sectionWrappers) {
                HeaderFooterPolicy hfp = sw.getHeaderFooterPolicy();
                if (header) {
                    if (hfp.getFirstHeader() != null) {
                        temp.addAll(DocExplorer.traversePartForBookmarkNames(hfp.getFirstHeader()));
                    }
                    if (hfp.getDefaultHeader() != null) {
                        temp.addAll(DocExplorer.traversePartForBookmarkNames(hfp.getDefaultHeader()));
                    }
                    if (hfp.getEvenHeader() != null) {
                        temp.addAll(DocExplorer.traversePartForBookmarkNames(hfp.getEvenHeader()));
                    }
                }
                if (!footer) continue;
                if (hfp.getFirstFooter() != null) {
                    temp.addAll(DocExplorer.traversePartForBookmarkNames(hfp.getFirstFooter()));
                }
                if (hfp.getDefaultFooter() != null) {
                    temp.addAll(DocExplorer.traversePartForBookmarkNames(hfp.getDefaultFooter()));
                }
                if (hfp.getEvenFooter() == null) continue;
                temp.addAll(DocExplorer.traversePartForBookmarkNames(hfp.getEvenFooter()));
            }
        }
        String[] anArray = new String[temp.size()];
        return temp.toArray(anArray);
    }

    private static BookmarkObject traversePartForBookmarkObject(Object parent, String bookmark) {
        BookmarkObject p = new BookmarkObject();
        bookmark = bookmark.toLowerCase();
        List children = TraversalUtil.getChildrenImpl((Object)parent);
        if (children != null) {
            for (Object o : children) {
                CTBookmark bm;
                if ((o = XmlUtils.unwrap(o)) instanceof CTBookmark && (bm = (CTBookmark)o).getName().toLowerCase().equals(bookmark)) {
                    p = new BookmarkObject((P)parent, bm);
                    return p;
                }
                p = DocExplorer.traversePartForBookmarkObject(o, bookmark);
                if (p.exists()) break;
            }
        }
        return p;
    }

    public static BookmarkObject getBookmarkObject(String bookmark, WordprocessingMLPackage wmlp) {
        BookmarkObject p = DocExplorer.traversePartForBookmarkObject(wmlp.getMainDocumentPart(), bookmark);
        if (!p.exists()) {
            List sectionWrappers = wmlp.getDocumentModel().getSections();
            for (SectionWrapper sw : sectionWrappers) {
                if (p.exists()) break;
                HeaderFooterPolicy hfp = sw.getHeaderFooterPolicy();
                if (!p.exists() && hfp.getFirstHeader() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getFirstHeader(), bookmark);
                }
                if (!p.exists() && hfp.getDefaultHeader() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getDefaultHeader(), bookmark);
                }
                if (!p.exists() && hfp.getEvenHeader() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getEvenHeader(), bookmark);
                }
                if (!p.exists() && hfp.getFirstFooter() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getFirstFooter(), bookmark);
                }
                if (!p.exists() && hfp.getDefaultFooter() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getDefaultFooter(), bookmark);
                }
                if (p.exists() || hfp.getEvenFooter() == null) continue;
                p = DocExplorer.traversePartForBookmarkObject(hfp.getEvenFooter(), bookmark);
            }
        }
        return p;
    }

    private static Vector<String> traversePartForStrings(Object parent) {
        Vector<String> out = new Vector<String>();
        List children = TraversalUtil.getChildrenImpl((Object)parent);
        if (children != null) {
            for (Object o : children) {
                if ((o = XmlUtils.unwrap(o)) instanceof Text) {
                    Text bm = (Text)o;
                    out.add(bm.getValue());
                    continue;
                }
                out.addAll(DocExplorer.traversePartForStrings(o));
            }
        }
        return out;
    }

    public static String[] getString(WordprocessingMLPackage wmlp, boolean body, boolean header, boolean footer) throws Exception {
        Vector<String> temp = new Vector<String>();
        if (body) {
            temp.addAll(DocExplorer.traversePartForStrings(wmlp.getMainDocumentPart()));
        }
        if (header || footer) {
            List sectionWrappers = wmlp.getDocumentModel().getSections();
            for (SectionWrapper sw : sectionWrappers) {
                HeaderFooterPolicy hfp = sw.getHeaderFooterPolicy();
                if (header) {
                    if (hfp.getFirstHeader() != null) {
                        temp.addAll(DocExplorer.traversePartForStrings(hfp.getFirstHeader()));
                    }
                    if (hfp.getDefaultHeader() != null) {
                        temp.addAll(DocExplorer.traversePartForStrings(hfp.getDefaultHeader()));
                    }
                    if (hfp.getEvenHeader() != null) {
                        temp.addAll(DocExplorer.traversePartForStrings(hfp.getEvenHeader()));
                    }
                }
                if (!footer) continue;
                if (hfp.getFirstFooter() != null) {
                    temp.addAll(DocExplorer.traversePartForStrings(hfp.getFirstFooter()));
                }
                if (hfp.getDefaultFooter() != null) {
                    temp.addAll(DocExplorer.traversePartForStrings(hfp.getDefaultFooter()));
                }
                if (hfp.getEvenFooter() == null) continue;
                temp.addAll(DocExplorer.traversePartForStrings(hfp.getEvenFooter()));
            }
        }
        String[] anArray = new String[temp.size()];
        return temp.toArray(anArray);
    }

    public static String[] getString(WordprocessingMLPackage wmlp, String bookmark) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, wmlp);
        if (!bo.exists()) {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
        Vector<String> temp = DocExplorer.traversePartForStrings(bo.getP());
        String[] anArray = new String[temp.size()];
        return temp.toArray(anArray);
    }
}

